# -*- coding: utf-8 -*-
"""

    Copyright (C) 2018

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    -------------------------------------------------------------

    Usage Examples:

<dir>
<title>fmovies</title>
<fmovies>movie</fmovies>
</dir>

"""    

import urllib
import zipfile
import urlparse
import time
import requests,re,json,os
import __builtin__
import xbmc,xbmcaddon,xbmcgui
from resources.lib.plugin import Plugin
from resources.lib.util.context import get_context_items
from resources.lib.util.xml import JenItem, JenList, display_list
from unidecode import unidecode
import koding
from koding import Add_Dir 
from koding import route, Run

CACHE_TIME = 3600  # change to wanted cache time in seconds
addon_fanart = xbmcaddon.Addon().getAddonInfo('fanart')
addon_icon = xbmcaddon.Addon().getAddonInfo('icon')
AddonName = xbmc.getInfoLabel('Container.PluginName')
AddonName = xbmcaddon.Addon(AddonName).getAddonInfo('id')
User_Agent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.84 Safari/537.36'

class FMovies(Plugin):
    name = "fmovies"

    def process_item(self, item_xml):
        if "<fmovies>" in item_xml:
            item = JenItem(item_xml)
            result_item = {
                'label': item["title"],
                'icon': item.get("thumbnail", addon_icon),
                'fanart': item.get("fanart", addon_fanart),
                'mode': "open_fmovies",
                'url': item.get("fmovies", ""),
                'folder': True,
                'imdb': "0",
                'content': "files",
                'season': "0",
                'episode': "0",
                'info': {},
                'year': "0",
                'context': get_context_items(item),
                "summary": item.get("summary", None)
            }
            result_item["properties"] = {
                'fanart_image': result_item["fanart"]
            }
            result_item['fanart_small'] = result_item["fanart"]
            return result_item


@route(mode='open_fmovies', args=["url"])
def get_movies(url):
    xml = ""
    headers = {'User_Agent':User_Agent}
    url2 = "https://fmovies.gg/"
    html = requests.get(url2,headers=headers).content
    block = re.compile('<h2>Suggestions</h2>(.+?)<h2>Sponsored</h2>',re.DOTALL).findall(html)
    match = re.compile('<img alt="(.+?)".+?src="(.+?)"',re.DOTALL).findall(str(block))
    for name, image in match:
        name = remove_non_ascii(name)
        image = "https:"+image    
        xml += "<item>"\
               "<title>%s</title>"\
               "<thumbnail>%s</thumbnail>"\
               "<fanart></fanart>"\
               "<link></link>"\
               "</item>" % (name,image) 
    jenlist = JenList(xml)
    display_list(jenlist.get_list(), jenlist.get_content_type()) 

def remove_non_ascii(text):
    text = text.replace("&#039;", "'")
    return unidecode(text)        
            