# -*- coding: utf-8 -*-

"""
    No Lives Matter Add-on
    ///Updated for No Lives Matter///

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""


import os,sys

import six

from resources.lib.modules import control
from resources.lib.modules import trakt
from resources.lib.modules import cache

sysaddon = sys.argv[0] ; syshandle = int(sys.argv[1])

artPath = control.artPath() ; addonFanart = control.addonFanart()

imdbCredentials = False if control.setting('imdb.user') == '' else True

traktCredentials = trakt.getTraktCredentialsInfo()

traktIndicators = trakt.getTraktIndicatorsInfo()

queueMenu = six.ensure_str(control.lang(32065))


class navigator:
    def root(self):
        self.addDirectoryItem(32001, 'movieNavigator', 'movies.png', 'DefaultMovies.png')
        self.addDirectoryItem(32002, 'tvNavigator', 'tvshows.png', 'DefaultTVShows.png')
        self.addDirectoryItem('24/7 Franchises', 'tfsfran', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('24/7 Collections', 'tfscoll', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('24/7 TV Shows', 'tfstv', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('24/7 Movies', 'tfsmov', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('24/7 Anthologies', 'tfsant', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('24/7 Stephen King', 'tfking', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('One Clicks', 'oneclicknav', 'icon.png', 'DefaultMovies.png')

        if not control.setting('lists.widget') == '0':
            self.addDirectoryItem(32003, 'mymovieNavigator', 'mymovies.png', 'DefaultVideoPlaylists.png')
            self.addDirectoryItem(32004, 'mytvNavigator', 'mytvshows.png', 'DefaultVideoPlaylists.png')

        if not control.setting('movie.widget') == '0':
            self.addDirectoryItem(32005, 'movieWidget', 'latest-movies.png', 'DefaultRecentlyAddedMovies.png')

        if (traktIndicators == True and not control.setting('tv.widget.alt') == '0') or (traktIndicators == False and not control.setting('tv.widget') == '0'):
            self.addDirectoryItem(32006, 'tvWidget', 'latest-episodes.png', 'DefaultRecentlyAddedEpisodes.png')

        if not control.setting('channels') == '0':
            self.addDirectoryItem(32007, 'channels', 'channels.png', 'DefaultMovies.png')

        if not control.setting('furk.api') == '':
            self.addDirectoryItem('Furk.net', 'furkNavigator', 'movies.png', 'movies.png')
        self.addDirectoryItem(32008, 'toolNavigator', 'tools.png', 'DefaultAddonProgram.png')

        downloads = True if control.setting('downloads') == 'true' and (len(control.listDir(control.setting('movie.download.path'))[0]) > 0 or len(control.listDir(control.setting('tv.download.path'))[0]) > 0) else False
        if downloads == True:
            self.addDirectoryItem(32009, 'downloadNavigator', 'downloads.png', 'DefaultFolder.png')

        self.addDirectoryItem(32010, 'searchNavigator', 'search.png', 'DefaultFolder.png')

        self.endDirectory()

    def furk(self):
        self.addDirectoryItem('User Files', 'furkUserFiles', 'mytvnavigator.png', 'mytvnavigator.png')
        self.addDirectoryItem('Search', 'furkSearch', 'search.png', 'search.png')
        self.endDirectory()

    def movies(self, lite=False):
        self.addDirectoryItem(32011, 'movieGenres', 'genres.png', 'DefaultMovies.png')
        self.addDirectoryItem(32012, 'movieYears', 'years.png', 'DefaultMovies.png')
        self.addDirectoryItem(32123, 'movieDecades', 'years.png', 'DefaultMovies.png')
        self.addDirectoryItem(32013, 'moviePersons', 'people.png', 'DefaultMovies.png')
        self.addDirectoryItem(32014, 'movieLanguages', 'languages.png', 'DefaultMovies.png')
        self.addDirectoryItem(32015, 'movieCertificates', 'certificates.png', 'DefaultMovies.png')
        self.addDirectoryItem(32017, 'movies&url=trending', 'people-watching.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem(32018, 'movies&url=popular', 'most-popular.png', 'DefaultMovies.png')
        self.addDirectoryItem(32019, 'movies&url=views', 'most-voted.png', 'DefaultMovies.png')
        self.addDirectoryItem(32020, 'movies&url=boxoffice', 'box-office.png', 'DefaultMovies.png')
        #self.addDirectoryItem(32021, 'movies&url=oscars', 'oscar-winners.png', 'DefaultMovies.png')
        self.addDirectoryItem(32022, 'movies&url=theaters', 'in-theaters.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem(32005, 'movieWidget', 'latest-movies.png', 'DefaultRecentlyAddedMovies.png')
        if lite == False:
            if not control.setting('lists.widget') == '0':
                self.addDirectoryItem(32003, 'mymovieliteNavigator', 'mymovies.png', 'DefaultVideoPlaylists.png')
            self.addDirectoryItem(32010, 'movieSearch', 'search.png', 'DefaultMovies.png')

        self.endDirectory()


    def mymovies(self, lite=False):
        self.accountCheck()

        if traktCredentials == True and imdbCredentials == True:
            self.addDirectoryItem(32094, 'movies&url=onDeck', 'trakt.png', 'DefaultMovies.png', queue=True)
            self.addDirectoryItem(32032, 'movies&url=traktcollection', 'trakt.png', 'DefaultMovies.png', queue=True, context=(32551, 'moviesToLibrary&url=traktcollection'))
            if control.setting('imdb.sort.order') == '1':
                self.addDirectoryItem(32034, 'movies&url=imdbwatchlist2', 'imdb.png', 'DefaultMovies.png', queue=True)
            else:
                self.addDirectoryItem(32034, 'movies&url=imdbwatchlist', 'imdb.png', 'DefaultMovies.png', queue=True)
            self.addDirectoryItem(32033, 'movies&url=traktwatchlist', 'trakt.png', 'DefaultMovies.png', queue=True, context=(32551, 'moviesToLibrary&url=traktwatchlist'))
            self.addDirectoryItem(32036, 'movies&url=trakthistory', 'trakt.png', 'DefaultMovies.png', queue=True)
            self.addDirectoryItem(32035, 'movies&url=traktfeatured', 'trakt.png', 'DefaultMovies.png', queue=True)

        elif traktCredentials == True:
            self.addDirectoryItem(32094, 'movies&url=onDeck', 'trakt.png', 'DefaultMovies.png', queue=True)
            self.addDirectoryItem(32032, 'movies&url=traktcollection', 'trakt.png', 'DefaultMovies.png', queue=True, context=(32551, 'moviesToLibrary&url=traktcollection'))
            self.addDirectoryItem(32033, 'movies&url=traktwatchlist', 'trakt.png', 'DefaultMovies.png', queue=True, context=(32551, 'moviesToLibrary&url=traktwatchlist'))
            self.addDirectoryItem(32036, 'movies&url=trakthistory', 'trakt.png', 'DefaultMovies.png', queue=True)
            self.addDirectoryItem(32035, 'movies&url=traktfeatured', 'trakt.png', 'DefaultMovies.png', queue=True)

        elif imdbCredentials == True:
            if control.setting('imdb.sort.order') == '1':
                self.addDirectoryItem(32034, 'movies&url=imdbwatchlist2', 'imdb.png', 'DefaultMovies.png', queue=True)
            else:
                self.addDirectoryItem(32034, 'movies&url=imdbwatchlist', 'imdb.png', 'DefaultMovies.png', queue=True)
            self.addDirectoryItem(32077, 'movies&url=featured', 'imdb.png', 'DefaultMovies.png', queue=True)

        self.addDirectoryItem(32039, 'movieUserlists', 'userlists.png', 'DefaultMovies.png')

        if lite == False:
            self.addDirectoryItem(32031, 'movieliteNavigator', 'movies.png', 'DefaultMovies.png')
            self.addDirectoryItem(32028, 'moviePerson', 'people-search.png', 'DefaultMovies.png')
            self.addDirectoryItem(32010, 'movieSearch', 'search.png', 'DefaultMovies.png')

        self.endDirectory()


    def tvshows(self, lite=False):
        self.addDirectoryItem(32011, 'tvGenres', 'genres.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32014, 'tvLanguages', 'languages.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32015, 'tvCertificates', 'certificates.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32018, 'tvshows&url=popular', 'most-popular.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32023, 'tvshows&url=rating', 'highly-rated.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32019, 'tvshows&url=views', 'most-voted.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32024, 'tvshows&url=airing', 'airing-today.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32016, 'tvNetworks', 'networks.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32026, 'tvshows&url=premiere', 'new-tvshows.png', 'DefaultTVShows.png')

        if lite == False:
            if not control.setting('lists.widget') == '0':
                self.addDirectoryItem(32004, 'mytvliteNavigator', 'mytvshows.png', 'DefaultVideoPlaylists.png')

            self.addDirectoryItem(32010, 'tvSearch', 'search.png', 'DefaultTVShows.png')

        self.endDirectory()


    def mytvshows(self, lite=False):
        try:
            self.accountCheck()

            if traktCredentials == True and imdbCredentials == True:

                self.addDirectoryItem(32094, 'calendar&url=onDeck', 'trakt.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32032, 'tvshows&url=traktcollection', 'trakt.png', 'DefaultTVShows.png', context=(32551, 'tvshowsToLibrary&url=traktcollection'))
                if control.setting('imdb.sort.order') == '1':
                    self.addDirectoryItem(32034, 'tvshows&url=imdbwatchlist2', 'imdb.png', 'DefaultTVShows.png')
                else:
                    self.addDirectoryItem(32034, 'tvshows&url=imdbwatchlist', 'imdb.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32033, 'tvshows&url=traktwatchlist', 'trakt.png', 'DefaultTVShows.png', context=(32551, 'tvshowsToLibrary&url=traktwatchlist'))
                self.addDirectoryItem(32035, 'tvshows&url=traktfeatured', 'trakt.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32036, 'calendar&url=trakthistory', 'trakt.png', 'DefaultTVShows.png', queue=True)
                self.addDirectoryItem(32037, 'calendar&url=progress', 'trakt.png', 'DefaultRecentlyAddedEpisodes.png', queue=True)
                self.addDirectoryItem(32038, 'calendar&url=mycalendar', 'trakt.png', 'DefaultRecentlyAddedEpisodes.png', queue=True)
                self.addDirectoryItem(32041, 'episodeUserlists', 'userlists.png', 'DefaultTVShows.png')

            elif traktCredentials == True:
                self.addDirectoryItem(32094, 'calendar&url=onDeck', 'trakt.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32032, 'tvshows&url=traktcollection', 'trakt.png', 'DefaultTVShows.png', context=(32551, 'tvshowsToLibrary&url=traktcollection'))
                self.addDirectoryItem(32033, 'tvshows&url=traktwatchlist', 'trakt.png', 'DefaultTVShows.png', context=(32551, 'tvshowsToLibrary&url=traktwatchlist'))
                self.addDirectoryItem(32035, 'tvshows&url=traktfeatured', 'trakt.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32036, 'calendar&url=trakthistory', 'trakt.png', 'DefaultTVShows.png', queue=True)
                self.addDirectoryItem(32037, 'calendar&url=progress', 'trakt.png', 'DefaultRecentlyAddedEpisodes.png', queue=True)
                self.addDirectoryItem(32038, 'calendar&url=mycalendar', 'trakt.png', 'DefaultRecentlyAddedEpisodes.png', queue=True)
                self.addDirectoryItem(32041, 'episodeUserlists', 'userlists.png', 'DefaultTVShows.png')

            elif imdbCredentials == True:
                if control.setting('imdb.sort.order') == '1':
                    self.addDirectoryItem(32034, 'tvshows&url=imdbwatchlist2', 'imdb.png', 'DefaultTVShows.png')
                else:
                    self.addDirectoryItem(32034, 'tvshows&url=imdbwatchlist', 'imdb.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32077, 'tvshows&url=trending', 'imdb.png', 'DefaultTVShows.png', queue=True)

            self.addDirectoryItem(32040, 'tvUserlists', 'userlists.png', 'DefaultTVShows.png')

            if lite == False:
                self.addDirectoryItem(32031, 'tvliteNavigator', 'tvshows.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32028, 'tvPerson', 'people-search.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32010, 'tvSearch', 'search.png', 'DefaultTVShows.png')

            self.endDirectory()
        except:
            print("ERROR")
            
    def tfsfran(self):
        self.addDirectoryItem('Aliens', 'aliensNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Anaconda', 'AnacondaNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Annabelle', 'AnnabelleNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Blade', 'bladeNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Childs Play', 'chuckyNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Candyman', 'candymanNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Dracula', 'DraculaNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Evil Dead', 'evilNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Final Destination', 'finalNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Frankenstien', 'frankenstienNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Friday the 13th', 'FridayNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Fright Night', 'FrightNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Ginger Snaps', ' gingersnapsNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Halloween', 'halloweenNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Hatchet', 'hatchetNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Hellraiser', 'hellraiserNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Insdious', 'insidiousNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Jaws', 'JawsNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Jeepers Creepers', 'creepersNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Joyride', 'joyrideNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Krampus', 'krampusNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Lake Placid', 'lakeplacidNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Leprechaun', 'lepNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Nightmare On Elm St', 'elmNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Paranormal Activity', 'paraNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Phantasm', 'PhantasmNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Pumkinhead', 'pumpkinheadNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Puppet Master', 'PuppetMasterNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Resident Evil', 'residentNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Return Of The Living Dead', 'livingNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Rob Zombie', 'robzNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Predator', 'PredatorNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Hills Have Eyes', 'TheHillsNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Lost Boys', 'lostboysNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Tales From The Crypt Movies', 'tftcNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Texas ChainSaw', 'texasNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The blob', 'theblobNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Underworld', 'UnderworldNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Werewolves', 'thepackNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Wishmaster', 'wishmasterNavigator', '247.png', 'DefaultTVShows.png')
        self.endDirectory()
        
    def tfscoll(self):
        self.addDirectoryItem('Animal Horror Movies', 'Animals1', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Folklore Movies', 'folkloreNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('George Romero', 'romeroNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('John Carpenter', 'carpenter', '247.png', 'DefaultTVShows.png')

        self.endDirectory()
        
    def tfstv(self):        
        self.addDirectoryItem('American Horror Stories', 'AmericanHorrorStoriesNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('American Horror Story', 'AmericanHorrorStoryNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Chucky Tv Series', 'chuckytvNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Creepshow', 'CreepshowNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Dracula', 'DraculaNavigator', '247.png', 'DefaultTVShows.png')	
        self.addDirectoryItem('Elviras 40th Anniversary Very Scary Very Special Special S01', 'Elviras40thAnniversaryNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Tales From The Crypt Tv Series', 'TalesFromTheCryptNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Courage the Cowardly Dog', 'CouragetheCowardlyDogNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Tales from the Cryptkeeper', 'TalesfromtheCryptkeeperNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Cursed Films S1', 'Cursed Filmss1', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Ash Vs Evil Dead S1', 'Ash Vs Evil Deads1', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Ash Vs Evil Dead S2', 'Ash Vs Evil Deads2', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Ash Vs Evil Dead S3', 'Ash Vs Evil Deads3', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Tales from the Darkside S1', 'Tales from the Darksides1', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Tales from the Darkside S2', 'Tales from the Darksides2', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Tales from the Darkside S3', 'Tales from the Darksides3', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Tales from the Darkside S4', 'Tales from the Darksides4', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Outer Limits 1963-1965 S1', 'The OuterLimits1', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Outer Limits 1963-1965 S2', 'The OuterLimits2', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Outer Limits S1', 'The Outer Limitss1', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Outer Limits S2', 'The Outer Limitss2', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Outer Limits S3', 'The Outer Limitss3', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Outer Limits S4', 'The Outer Limitss4', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Outer Limits S5', 'The Outer Limitss5', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Outer Limits S6', 'The Outer Limitss6', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Outer Limits S7', 'The Outer Limitss7', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Twilight Zone - 2002', 'The Twilight Zone - 2002', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Twilight Zone 1959 S1', 'The Twilight Zone 1959s1', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Twilight Zone 1959 S2', 'The Twilight Zone 1959s2', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Twilight Zone 1959 S3', 'The Twilight Zone 1959s3', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Twilight Zone 1959 S4', 'The Twilight Zone 1959s4', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Twilight Zone 1959 S5', 'The Twilight Zone 1959s5', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Twilight Zone 1985 S1', 'The Twilight Zone 1985s1', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Twilight Zone 1985 S2', 'The Twilight Zone 1985s2', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Twilight Zone 1985 S3', 'The Twilight Zone 1985s3', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Werewolf 1987', 'Werewolf 1987', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Freddys Nightmares S1', 'Freddys Nightmaress1', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Freddys Nightmares S2', 'Freddys Nightmaress2', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('friday the 13th S1', 'friday the 13ths1', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('friday the 13th S2', 'friday the 13ths2', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('friday the 13th S3', 'friday the 13ths3', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Slasher S1', 'Slasher S1', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Slasher S2', 'Slasher S2', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Slasher S3', 'Slasher S3', '247.png', 'DefaultTVShows.png')
        self.endDirectory()
        
    def tfsant(self):        
        self.addDirectoryItem('Hammer House Tv Series', 'hammerNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Horror Movies', 'horror mov', '247.png', 'DefaultTVShows.png')

        self.endDirectory()
    
    def tfstvking(self):        
        self.addDirectoryItem('11 22 63', '112263Navigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Bag of Bones', 'BagofBonesNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Chapel Waite', 'Chapelwaite', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('IT', 'ItNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Storm Of The Century', 'sotcNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Liseys Story', 'LiseysStoryNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Nightmares And Dreamscapes', 'NadNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Rose Red', 'roseNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Outsider', 'outsiderNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Shining', 'shiningNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Stand 2020', 'thestandtwentyNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Tommy Knockers', 'tkNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Mist', 'mistNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('The Stand', 'thestandNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('King Movies', 'movkingNavigator', '247.png', 'DefaultTVShows.png')
        self.endDirectory()

    def tfsmov(self):       
        self.addDirectoryItem('Classic Horrors Nothing Above 1990', '247classichorNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Random Horror', 'horrorNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Movies Based On Poe', 'poeNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Shock Docs Not For Kids', 'shockdocsNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('Killer Bells', 'killerbellsNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('80s Horror', '80shorrorNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('70s Horror', '70sNavigator', '247.png', 'DefaultTVShows.png')
        self.endDirectory()

    def tools(self):
        self.addDirectoryItem('[B]No Lives Matter[/B] : Changelog', 'changelog', 'tools.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32043, 'openSettings&query=0.0', 'tools.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32556, 'libraryNavigator', 'tools.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem(32049, 'viewsNavigator', 'tools.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem(32604, 'clearCacheSearch', 'tools.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32050, 'clearSources', 'tools.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32116, 'clearDebridCheck', 'tools.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32052, 'clearCache', 'tools.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32611, 'clearAllCache', 'tools.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32108, 'cleanSettings', 'tools.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32079, 'wolfpackscrapersettings', 'icon.png', 'DefaultAddonProgram.png', isFolder=False)
        if not control.condVisibility('System.HasAddon(script.module.orion)'):
            self.addDirectoryItem('[B]Orion[/B] : Install', 'installOrion', 'orion.png', 'DefaultAddonProgram.png', isFolder=False)
        else:
            self.addDirectoryItem(32080, 'orionsettings', 'orion.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32076, 'smuSettings', 'resolveurl.png', 'DefaultAddonProgram.png', isFolder=False)
        if trakt.getTraktCredentialsInfo():
            self.addDirectoryItem(32093, 'syncTraktStatus', 'trakt.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32073, 'authTrakt', 'trakt.png', 'DefaultAddonProgram.png', isFolder=False)

        self.endDirectory()

    def library(self):
        self.addDirectoryItem(32557, 'openSettings&query=6.0', 'tools.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32558, 'updateLibrary&query=tool', 'library_update.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32559, control.setting('library.movie'), 'movies.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem(32560, control.setting('library.tv'), 'tvshows.png', 'DefaultTVShows.png', isAction=False)

        if trakt.getTraktCredentialsInfo():
            self.addDirectoryItem(32561, 'moviesToLibrary&url=traktcollection', 'trakt.png', 'DefaultMovies.png', isFolder=False)
            self.addDirectoryItem(32562, 'moviesToLibrary&url=traktwatchlist', 'trakt.png', 'DefaultMovies.png', isFolder=False)
            self.addDirectoryItem(32563, 'tvshowsToLibrary&url=traktcollection', 'trakt.png', 'DefaultTVShows.png', isFolder=False)
            self.addDirectoryItem(32564, 'tvshowsToLibrary&url=traktwatchlist', 'trakt.png', 'DefaultTVShows.png', isFolder=False)

        self.endDirectory()

    def ocsklicklibrary(self):
        self.addDirectoryItem('Horror Movie Anthologies', control.setting('library.horrormov'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Hammer House Tv Series', control.setting('library.hammer'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Slasher', control.setting('library.Slasher'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Friday the 13th', control.setting('library.fridaythe13th'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Freddys Nightmares', control.setting('library.FreddysNightmares'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Werewolf', control.setting('library.Werewolf'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('The Twilight Zone 1985', control.setting('library.TheTwilightZone1985'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('The Twilight Zone 1959', control.setting('library.TheTwilightZone1959'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Twilight Zone - 2002', control.setting('library.TwilightZone2002'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('The Outer Limits', control.setting('library.TheOuterLimits'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('The Outer Limits 1963-1965', control.setting('library.TheOuterLimits1963-1965'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Tales from the Darkside', control.setting('library.TalesfromtheDarkside'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Ash Vs Evil Dead', control.setting('library.AshVsEvilDead'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Cursed Films', control.setting('library.CursedFilms'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Tales from the Cryptkeeper', control.setting('library.TalesfromtheCryptkeeper'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Courage the Cowardly Dog', control.setting('library.CouragetheCowardlyDog'), 'icon.png', 'DefaultMovies.png', isAction=False) 
        self.addDirectoryItem('Chucky', control.setting('library.chucky'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Tales From The Crypt', control.setting('library.TalesFromTheCrypt'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Elviras 40th Anniversary', control.setting('library.Elviras40thAnniversary'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Creepshow', control.setting('library.Creepshow'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Dracula', control.setting('library.Dracula'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('American Horror Story', control.setting('library.AmericanHorrorStory'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('American Horror Stories', control.setting('library.AmericanHorrorStories'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Classic Horrors Nothing Above 1990', control.setting('library.247classic'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Horror Movies', control.setting('library.horror'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Based On Poe Movies', control.setting('library.poe'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Shock Docs Not For Kids', control.setting('library.shockdocs'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Killer Bells', control.setting('library.killerbells'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('80s Horror', control.setting('library.80shorror'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('70s Horror', control.setting('library.70s'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Horror Franchises', control.setting('library.HorrorFranchises'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Animal Horror Movies ', control.setting('library.Animals1'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('Folklore Movies', control.setting('library.folklore'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('George Romero', control.setting('library.romero'), 'icon.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem('John Carpenter', control.setting('library.carpenter'), 'icon.png', 'DefaultMovies.png', isAction=False)

        if trakt.getTraktCredentialsInfo():
            self.addDirectoryItem(32561, 'moviesToLibrary&url=traktcollection', 'trakt.png', 'DefaultMovies.png', isFolder=False)
            self.addDirectoryItem(32562, 'moviesToLibrary&url=traktwatchlist', 'trakt.png', 'DefaultMovies.png', isFolder=False)
            self.addDirectoryItem(32563, 'tvshowsToLibrary&url=traktcollection', 'trakt.png', 'DefaultTVShows.png', isFolder=False)
            self.addDirectoryItem(32564, 'tvshowsToLibrary&url=traktwatchlist', 'trakt.png', 'DefaultTVShows.png', isFolder=False)

        self.endDirectory()

    def downloads(self):
        movie_downloads = control.setting('movie.download.path')
        tv_downloads = control.setting('tv.download.path')

        if len(control.listDir(movie_downloads)[0]) > 0:
            self.addDirectoryItem(32001, movie_downloads, 'movies.png', 'DefaultMovies.png', isAction=False)
        if len(control.listDir(tv_downloads)[0]) > 0:
            self.addDirectoryItem(32002, tv_downloads, 'tvshows.png', 'DefaultTVShows.png', isAction=False)

        self.endDirectory()


    def search(self):
        self.addDirectoryItem(32001, 'movieSearch', 'search.png', 'DefaultMovies.png')
        self.addDirectoryItem(32002, 'tvSearch', 'search.png', 'DefaultTVShows.png')

        self.endDirectory()

    def views(self):
        try:
            control.idle()

            items = [ (six.ensure_str(control.lang(32001)), 'movies'), (six.ensure_str(control.lang(32002)), 'tvshows'), (six.ensure_str(control.lang(32054)), 'seasons'), (six.ensure_str(control.lang(32038)), 'episodes') ]

            select = control.selectDialog([i[0] for i in items], six.ensure_str(control.lang(32049)))

            if select == -1: return

            content = items[select][1]

            title = six.ensure_str(control.lang(32059))
            url = '%s?action=addView&content=%s' % (sys.argv[0], content)

            poster, banner, fanart = control.addonPoster(), control.addonBanner(), control.addonFanart()

            item = control.item(label=title)
            item.setInfo(type='Video', infoLabels = {'title': title})
            item.setArt({'icon': poster, 'thumb': poster, 'poster': poster, 'banner': banner})
            item.setProperty('Fanart_Image', fanart)

            control.addItem(handle=int(sys.argv[1]), url=url, listitem=item, isFolder=False)
            control.content(int(sys.argv[1]), content)
            control.directory(int(sys.argv[1]), cacheToDisc=True)

            from resources.lib.modules import views
            views.setView(content, {})
        except:
            return


    def accountCheck(self):
        if traktCredentials == False and imdbCredentials == False:
            control.idle()
            control.infoDialog(six.ensure_str(control.lang(32042)), sound=True, icon='WARNING')
            sys.exit()


    def infoCheck(self, version):
        try:
            control.infoDialog('', six.ensure_str(control.lang(32074)), time=5000, sound=False)
            return '1'
        except:
            return '1'


    def clearCache(self):
        #control.idle()
        yes = control.yesnoDialog(control.lang(32056))
        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear()
        control.infoDialog(six.ensure_str(control.lang(32057)), sound=True, icon='INFO')

    def clearCacheMeta(self):
        #control.idle()
        yes = control.yesnoDialog(control.lang(32056))
        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear_meta()
        control.infoDialog(six.ensure_str(control.lang(32057)), sound=True, icon='INFO')

    def clearCacheProviders(self):
        #control.idle()
#        yes = control.yesnoDialog(control.lang(32056))
#        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear_providers()
        control.infoDialog(six.ensure_str(control.lang(32057)), sound=True, icon='INFO')

    def clearCacheSearch(self):
        #control.idle()
        yes = control.yesnoDialog(control.lang(32056))
        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear_search()
        control.infoDialog(six.ensure_str(control.lang(32057)), sound=True, icon='INFO')

    def clearDebridCheck(self):
        #control.idle()
        yes = control.yesnoDialog(control.lang(32056))
        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear_debrid()
        control.infoDialog(six.ensure_str(control.lang(32057)), sound=True, icon='INFO')

    def clearCacheAll(self):
        #control.idle()
        yes = control.yesnoDialog(control.lang(32056))
        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear_all()
        control.infoDialog(six.ensure_str(control.lang(32057)), sound=True, icon='INFO')

    def addDirectoryItem(self, name, query, thumb, icon, context=None, queue=False, isAction=True, isFolder=True):
        try: name = six.ensure_str(control.lang(name))
        except: pass
        url = '%s?action=%s' % (sysaddon, query) if isAction == True else query
        thumb = os.path.join(artPath, thumb) if not artPath == None else icon
        cm = []
        if queue == True: cm.append((queueMenu, 'RunPlugin(%s?action=queueItem)' % sysaddon))
        if not context == None: cm.append((six.ensure_str(control.lang(context[0])), 'RunPlugin(%s?action=%s)' % (sysaddon, context[1])))
        item = control.item(label=name)
        item.addContextMenuItems(cm)
        item.setArt({'icon': thumb, 'thumb': thumb})
        if not addonFanart == None: item.setProperty('Fanart_Image', addonFanart)
        control.addItem(handle=syshandle, url=url, listitem=item, isFolder=isFolder)

    def endDirectory(self, cache=True):
        control.content(syshandle, 'addons')
        control.directory(syshandle, cacheToDisc=cache)
