# -*- coding: utf-8 -*-

'''
    exodus Add-on

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''


import sys
from six.moves import urllib_parse
import xbmcgui

params = dict(urllib_parse.parse_qsl(sys.argv[2].replace('?','')))

action = params.get('action')

name = params.get('name')

title = params.get('title')

year = params.get('year')

imdb = params.get('imdb')

tvdb = params.get('tvdb')

tmdb = params.get('tmdb')

season = params.get('season')

episode = params.get('episode')

tvshowtitle = params.get('tvshowtitle')

premiered = params.get('premiered')

url = params.get('url')

image = params.get('image')

meta = params.get('meta')

select = params.get('select')

query = params.get('query')

source = params.get('source')

content = params.get('content')

windowedtrailer = params.get('windowedtrailer')
windowedtrailer = int(windowedtrailer) if windowedtrailer in ("0","1") else 0


if action == None:
    from resources.lib.indexers import navigator
    from resources.lib.modules import cache
    from resources.lib.modules import control
    cache.cache_version_check()
    if control.setting('startup.sync.trakt.status') == 'true':
        from resources.lib.modules import trakt
        trakt.syncTraktStatus()
    navigator.navigator().root()

elif action == "furkNavigator":
    from resources.lib.indexers import navigator
    navigator.navigator().furk()

elif action == "furkMetaSearch":
    from resources.lib.indexers import furk
    furk.furk().furk_meta_search(url)

elif action == "furkSearch":
    from resources.lib.indexers import furk
    furk.furk().search()

elif action == "furkUserFiles":
    from resources.lib.indexers import furk
    furk.furk().user_files()

elif action == "furkSearchNew":
    from resources.lib.indexers import furk
    furk.furk().search_new()

elif action == 'movieNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().movies()

elif action == 'movieliteNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().movies(lite=True)

elif action == 'mymovieNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().mymovies()

elif action == 'mymovieliteNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().mymovies(lite=True)

elif action == 'tvNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().tvshows()

elif action == 'tvliteNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().tvshows(lite=True)

elif action == 'mytvNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().mytvshows()

elif action == 'mytvliteNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().mytvshows(lite=True)


elif action == 'downloadNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().downloads()

elif action == 'libraryNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().library()

elif action == 'toolNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().tools()

elif action == 'searchNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().search()

elif action == 'viewsNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().views()

elif action == 'clearCache':
    from resources.lib.indexers import navigator
    navigator.navigator().clearCache()

elif action == 'clearCacheProviders':
    from resources.lib.indexers import navigator
    navigator.navigator().clearCacheProviders()

elif action == 'clearDebridCheck':
    from resources.lib.indexers import navigator
    navigator.navigator().clearDebridCheck()

elif action == 'clearCacheSearch':
    from resources.lib.indexers import navigator
    navigator.navigator().clearCacheSearch()

elif action == 'clearAllCache':
    from resources.lib.indexers import navigator
    navigator.navigator().clearCacheAll()

elif action == 'infoCheck':
    from resources.lib.indexers import navigator
    navigator.navigator().infoCheck('')

elif action == 'movies':
    from resources.lib.indexers import movies
    movies.movies().get(url)

elif action == 'moviePage':
    from resources.lib.indexers import movies
    movies.movies().get(url)

elif action == 'movieWidget':
    from resources.lib.indexers import movies
    movies.movies().widget()

elif action == 'movieSearch':
    from resources.lib.indexers import movies
    movies.movies().search()

elif action == 'movieSearchnew':
    from resources.lib.indexers import movies
    movies.movies().search_new()

elif action == 'movieSearchterm':
    from resources.lib.indexers import movies
    movies.movies().search_term(name)

elif action == 'moviePerson':
    from resources.lib.indexers import movies
    movies.movies().person()

elif action == 'movieGenres':
    from resources.lib.indexers import movies
    movies.movies().genres()

elif action == 'movieLanguages':
    from resources.lib.indexers import movies
    movies.movies().languages()

elif action == 'movieCertificates':
    from resources.lib.indexers import movies
    movies.movies().certifications()

elif action == 'movieYears':
    from resources.lib.indexers import movies
    movies.movies().years()

elif action == 'movieDecades':
    from resources.lib.indexers import movies
    movies.movies().decades()

elif action == 'moviePersons':
    from resources.lib.indexers import movies
    movies.movies().persons(url)

elif action == 'movieUserlists':
    from resources.lib.indexers import movies
    movies.movies().userlists()

elif action == 'channels':
    from resources.lib.indexers import channels
    channels.channels().get()

elif action == 'tvshows':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().get(url)

elif action == 'tvshowPage':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().get(url)

elif action == 'tvSearch':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().search()

elif action == 'tvSearchnew':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().search_new()

elif action == 'tvSearchterm':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().search_term(name)
    
elif action == 'tvPerson':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().person()

elif action == 'tvGenres':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().genres()

elif action == 'tvNetworks':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().networks()

elif action == 'tvLanguages':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().languages()

elif action == 'tvCertificates':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().certifications()

elif action == 'tvPersons':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().persons(url)

elif action == 'tvUserlists':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().userlists()

elif action == 'seasons':
    from resources.lib.indexers import episodes
    episodes.seasons().get(tvshowtitle, year, imdb, tvdb)

elif action == 'episodes':
    from resources.lib.indexers import episodes
    episodes.episodes().get(tvshowtitle, year, imdb, tvdb, season, episode)

elif action == 'calendar':
    from resources.lib.indexers import episodes
    episodes.episodes().calendar(url)

elif action == 'tvWidget':
    from resources.lib.indexers import episodes
    episodes.episodes().widget()

elif action == 'calendars':
    from resources.lib.indexers import episodes
    episodes.episodes().calendars()

elif action == 'episodeUserlists':
    from resources.lib.indexers import episodes
    episodes.episodes().userlists()

elif action == 'refresh':
    from resources.lib.modules import control
    control.refresh()

elif action == 'queueItem':
    from resources.lib.modules import control
    control.queueItem()

elif action == 'openSettings':
    from resources.lib.modules import control
    control.openSettings(query)

elif action == 'artwork':
    from resources.lib.modules import control
    control.artwork()

elif action == 'addView':
    from resources.lib.modules import views
    views.addView(content)

elif action == 'moviePlaycount':
    from resources.lib.modules import playcount
    playcount.movies(imdb, query)

elif action == 'episodePlaycount':
    from resources.lib.modules import playcount
    playcount.episodes(imdb, tvdb, season, episode, query)

elif action == 'tvPlaycount':
    from resources.lib.modules import playcount
    playcount.tvshows(name, imdb, tvdb, season, query)

elif action == 'trailer':
    from resources.lib.modules import trailer
    trailer.trailer().play(name, url, windowedtrailer)

elif action == 'traktManager':
    from resources.lib.modules import trakt
    trakt.manager(name, imdb, tvdb, content)

elif action == 'authTrakt':
    from resources.lib.modules import trakt
    trakt.authTrakt()

elif action == 'smuSettings':
    try: import resolveurl
    except: pass
    resolveurl.display_settings()

elif action == 'wolfpackscrapersettings':
    from resources.lib.modules import control
    control.openSettings('0.0', 'script.module.wolfpackscrapers')

elif action == 'installOrion':
    from resources.lib.modules import control
    control.installAddon('script.module.orion')
    control.sleep(200)
    control.refresh()

elif action == 'orionsettings':
    from resources.lib.modules import control
    control.openSettings('0.0', 'script.module.orion')

elif action == 'download':
    import simplejson as json
    from resources.lib.modules import sources
    from resources.lib.modules import downloader
    try: downloader.download(name, image, sources.sources().sourcesResolve(json.loads(source)[0], True))
    except: pass

elif action == 'play':
    from resources.lib.modules import control
    control.busy()
    from resources.lib.modules import sources
    sources.sources().play(title, year, imdb, tvdb, season, episode, tvshowtitle, premiered, meta, select)

elif action == 'addItem':
    from resources.lib.modules import sources
    sources.sources().addItem(title)

elif action == 'playItem':
    from resources.lib.modules import sources
    sources.sources().playItem(title, source)

elif action == 'alterSources':
    from resources.lib.modules import sources
    sources.sources().alterSources(url, meta)

elif action == 'clearSources':
    from resources.lib.modules import sources
    sources.sources().clearSources()

elif action == 'random':
    rtype = params.get('rtype')
    if rtype == 'movie':
        from resources.lib.indexers import movies
        rlist = movies.movies().get(url, create_directory=False)
        r = sys.argv[0]+"?action=play"
    elif rtype == 'episode':
        from resources.lib.indexers import episodes
        rlist = episodes.episodes().get(tvshowtitle, year, imdb, tvdb, season, create_directory=False)
        r = sys.argv[0]+"?action=play"
    elif rtype == 'season':
        from resources.lib.indexers import episodes
        rlist = episodes.seasons().get(tvshowtitle, year, imdb, tvdb, create_directory=False)
        r = sys.argv[0]+"?action=random&rtype=episode"
    elif rtype == 'show':
        from resources.lib.indexers import tvshows
        rlist = tvshows.tvshows().get(url, create_directory=False)
        r = sys.argv[0]+"?action=random&rtype=season"
    from random import randint
    import simplejson as json
    try:
        from resources.lib.modules import control
        rand = randint(1,len(rlist))-1
        for p in ['title','year','imdb','tvdb','season','episode','tvshowtitle','premiered','select']:
            if rtype == "show" and p == "tvshowtitle":
                try: r += '&'+p+'='+urllib_parse.quote_plus(rlist[rand]['originaltitle'])
                except: pass
            else:
                if rtype == "movie":
                    rlist[rand]['title'] = rlist[rand]['originaltitle']
                elif rtype == "episode":
                    rlist[rand]['tvshowtitle'] = urllib_parse.unquote_plus(rlist[rand]['tvshowtitle'])
                try: r += '&'+p+'='+urllib_parse.quote_plus(rlist[rand][p])
                except: pass
        try: r += '&meta='+urllib_parse.quote_plus(json.dumps(rlist[rand]))
        except: r += '&meta={}'
        if rtype == "movie":
            try: control.infoDialog('%s (%s)' % (rlist[rand]['title'], rlist[rand]['year']), control.lang(32536), time=20000)
            except: pass
        elif rtype == "episode":
            try: control.infoDialog('%s - %01dx%02d . %s' % (urllib_parse.unquote_plus(rlist[rand]['tvshowtitle']), int(rlist[rand]['season']), int(rlist[rand]['episode']), rlist[rand]['title']), control.lang(32536), time=20000)
            except: pass
        control.execute('RunPlugin(%s)' % r)
    except:
        from resources.lib.modules import control
        control.infoDialog(control.lang(32537), time=8000)

elif action == 'movieToLibrary':
    from resources.lib.modules import libtools
    libtools.libmovies().add(name, title, year, imdb, tmdb)

elif action == 'moviesToLibrary':
    from resources.lib.modules import libtools
    libtools.libmovies().range(url)

elif action == 'moviesToLibrarySilent':
    from resources.lib.modules import libtools
    libtools.libmovies().silent(url)

elif action == 'tvshowToLibrary':
    from resources.lib.modules import libtools
    libtools.libtvshows().add(tvshowtitle, year, imdb, tvdb)

elif action == 'tvshowsToLibrary':
    from resources.lib.modules import libtools
    libtools.libtvshows().range(url)

elif action == 'tvshowsToLibrarySilent':
    from resources.lib.modules import libtools
    libtools.libtvshows().silent(url)

elif action == 'updateLibrary':
    from resources.lib.modules import libtools
    libtools.libepisodes().update(query)

elif action == 'service':
    from resources.lib.modules import libtools
    libtools.libepisodes().service()

elif action == 'syncTraktStatus':
    from resources.lib.modules import trakt
    trakt.syncTraktStatus()

elif action == 'changelog':
    from resources.lib.modules import changelog
    changelog.get()	

elif action == 'cleanSettings':
    from resources.lib.modules import control
    control.clean_settings()
    
elif action == "tfsfran":
    from resources.lib.indexers import navigator
    navigator.navigator().tfsfran()  

elif action == 'AnacondaNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/Anaconda/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'lakeplacidNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/lakeplacid/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'AnnabelleNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/Annabelle/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'DraculaNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/Dracula/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'FridayNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/Friday/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'FrightNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/Fright/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'JawsNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/Jaws/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'PhantasmNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/Phantasm/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'PredatorNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/Predator/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'PuppetMasterNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/Puppet%20Master%20Collection%20%5bZomBiRG%5d/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'TheHillsNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/TheHills/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'UnderworldNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/Underworld/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'aliensNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/aliens/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'bladeNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/blade/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'candymanNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/candyman/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'chuckyNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/chucky/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'creepersNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/creepers/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'elmNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/elm/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'evilNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/evil/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'frankenstienNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/frankenstien/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'gingersnapsNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/gingersnaps/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'halloweenNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/halloween/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'hatchetNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/hatchet/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'hellraiserNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/hellraiser/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'insidiousNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/insidious/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'joyrideNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/joyride/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'krampusNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/krampus/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'lepNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/lep/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'livingNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/living/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'lostboysNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/lostboys/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'pumpkinheadNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/pumpkinhead/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'robzNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/robz/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
	
elif action == 'texasNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/texas/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'tftcNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/tftc/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'theblobNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/theblob/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'thepackNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/thepack/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'wishmasterNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/wishmaster/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'paraNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/paranormalact/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'residentNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/resident/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'finalNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/final/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')

##################################247 Tv ######################################################################

elif action == "tfstv":
    from resources.lib.indexers import navigator
    navigator.navigator().tfstv()
	
elif action == 'AmericanHorrorStoriesNavigator':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/American.Horror.Stories/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'AmericanHorrorStoryNavigator':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/American%20Horror%20Story/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'CreepshowNavigator':
    xbmc.executebuiltin('https://tv.encrypticmh.appboxes.co/Creepshow/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'DraculaNavigator':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/Dracula%20(2020)%20Season-01%20Complete%20720p%20NETFLIX%20WEB-DL%20Dual%20Audio%20%5bHindi+English%5d%20AAC%20DD-2.0%20x264%20Esub/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'Elviras40thAnniversaryNavigator':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/Elviras.40th.Anniversary.Very.Scary.Very.Special.Special.S01.1080p.AMZN.WEBRip.DDP2.0.x264-WHOSNEXT%5beztv.re%5d/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'TalesFromTheCryptNavigator':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/Tales.From.The.Crypt/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'chuckytvNavigator':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/chucky/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'CouragetheCowardlyDogNavigator':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/kids/Courage.the.Cowardly.Dog/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'TalesfromtheCryptkeeperNavigator':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/kids/Tales%20from%20the%20Cryptkeeper/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'Cursed Filmss1':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/Cursed%20Films/Season%201/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'Ash Vs Evil Deads1':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/Ash%20Vs%20Evil%20Dead/Season%201/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'Ash Vs Evil Deads2':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/Ash%20Vs%20Evil%20Dead/Season%202/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'Ash Vs Evil Deads3':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/Ash%20Vs%20Evil%20Dead/Season%203/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'Tales from the Darksides1':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/Tales%20from%20the%20Darkside/Season%2001/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'Tales from the Darksides2':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/Tales%20from%20the%20Darkside/Season%2002/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'Tales from the Darksides3':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/Tales%20from%20the%20Darkside/Season%2003/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'Tales from the Darksides4':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/Tales%20from%20the%20Darkside/Season%2004/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'The OuterLimits1':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Outer%20Limits(1963-1965)%5bSeasons%2001-02%20Complete%5d%20DVDRip/Season%2001/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'The OuterLimits2':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Outer%20Limits(1963-1965)%5bSeasons%2001-02%20Complete%5d%20DVDRip/Season%2002/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'The Outer Limitss1':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Outer%20Limits/Season%201%20-%20Complete/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'The Outer Limitss2':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Outer%20Limits/Season%202%20-%20Complete/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'The Outer Limitss3':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Outer%20Limits/Season%203%20-%20Complete/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'The Outer Limitss4':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Outer%20Limits/Season%204%20-%20Complete/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'The Outer Limitss5':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Outer%20Limits/Season%205%20-%20Complete/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'The Outer Limitss6':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Outer%20Limits/Season%206%20-%20Complete/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'The Outer Limitss7':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Outer%20Limits/Season%207%20-%20Complete/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'The Twilight Zone - 2002':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Twilight%20Zone%20-%202002/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'The Twilight Zone 1959s1':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Twilight%20Zone%201959%20S01-S05%20(1959-)/The%20Twilight%20Zone%201959%20S01%20(360p%20re-dvdrip)/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'The Twilight Zone 1959s2':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Twilight%20Zone%201959%20S01-S05%20(1959-)/The%20Twilight%20Zone%201959%20S02%20(360p%20re-dvdrip)/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'The Twilight Zone 1959s3':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Twilight%20Zone%201959%20S01-S05%20(1959-)/The%20Twilight%20Zone%201959%20S03%20(360p%20re-dvdrip)/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'The Twilight Zone 1959s4':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Twilight%20Zone%201959%20S01-S05%20(1959-)/The%20Twilight%20Zone%201959%20S04%20(360p%20re-dvdrip)/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'The Twilight Zone 1959s5':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Twilight%20Zone%201959%20S01-S05%20(1959-)/The%20Twilight%20Zone%201959%20S05%20(360p%20re-dvdrip)/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'The Twilight Zone 1985s1':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Twilight%20Zone%201985/The%20Twilight%20Zone%201985%20S01%20(360p%20re-dvdrip)/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'The Twilight Zone 1985s2':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Twilight%20Zone%201985/The%20Twilight%20Zone%201985%20S02%20(360p%20re-dvdrip)/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'The Twilight Zone 1985s3':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Twilight%20Zone%201985/The%20Twilight%20Zone%201985%20S03%20(360p%20re-dvdrip)/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'Werewolf 1987':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/Werewolf%201987%20Season%201%20Complete%20WEB%20x264%20%5bi_c%5d/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'Freddys Nightmaress1':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/freddy/Freddys%20Nightmares.S01/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'Freddys Nightmaress2':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/freddy/Freddys.Nightmares.S02/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'friday the 13ths1':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/friday%20the%2013th/Friday%20the%2013th%20The%20Series%201987%20Season%201%20Complete%20DVDRip%20x264%20%5bi_c%5d/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'friday the 13ths2':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/friday%20the%2013th/Friday%20the%2013th%20The%20Series%201987%20Season%202%20Complete%20DVDRip%20x264%20%5bi_c%5d/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'friday the 13ths3':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/friday%20the%2013th/Friday%20the%2013th%20The%20Series%201987%20Season%203%20Complete%20DVDRip%20x264%20%5bi_c%5d/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'Slasher S3':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/slasher/Slasher.S03.COMPLETE.WEB.x264-STRiFE%5bTGx%5d/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'Slasher S1':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/slasher/Slasher%202016%20Season%201%20Complete%20720p%20BluRay%20x264%20%5bi_c%5d/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'Slasher S2':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/slasher/Slasher%202016%20Season%202%20Complete%20720p%20BluRay%20x264%20%5bi_c%5d/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')



##################################247 Collections ######################################################################

elif action == "tfscoll":
    from resources.lib.indexers import navigator
    navigator.navigator().tfscoll()
    
elif action == 'carpenter':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/carpenter/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'Animals1':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/animals/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'romeroNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/romero/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'folkloreNavigator':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/folklore/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')


##################################247 movies ######################################################################

elif action == "tfsmov":
    from resources.lib.indexers import navigator
    navigator.navigator().tfsmov()

elif action == '247classichorNavigator':
    xbmc.executebuiltin('PlayMedia(https://movies.encrypticmh.appboxes.co/247classichor/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'horrorNavigator':
    xbmc.executebuiltin('PlayMedia(https://movies.encrypticmh.appboxes.co/horror/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'poeNavigator':
    xbmc.executebuiltin('PlayMedia(https://movies.encrypticmh.appboxes.co/poe/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'shockdocsNavigator':
    xbmc.executebuiltin('PlayMedia(https://movies.encrypticmh.appboxes.co/shockdocs/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == 'killerbellsNavigator':
    xbmc.executebuiltin('PlayMedia(https://movies.encrypticmh.appboxes.co/killerbells/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == '80shorrorNavigator':
    xbmc.executebuiltin('PlayMedia(https://movies.encrypticmh.appboxes.co/80shorror/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
	
elif action == '70sNavigator':
    xbmc.executebuiltin('PlayMedia(https://movies.encrypticmh.appboxes.co/70s/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')

##################################247 Anthologies######################################################################

elif action == "tfsant":
    from resources.lib.indexers import navigator
    navigator.navigator().tfsant()

elif action == 'horror mov':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/anthologies/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'hammerNavigator':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/tvanthologies/Hammer.House.of.Horror.S01.REMASTERED.BDRip.x264-OUIJA%5brartv%5d/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')

##################################247 Stephen King######################################################################

elif action == "tfking":
    from resources.lib.indexers import navigator
    navigator.navigator().tfstvking()

elif action == '112263Navigator':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/king/miniseries/11.22.63/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'BagofBonesNavigator':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/king/miniseries/Bag.of.Bones/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'ChapelwaiteNavigator':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/king/miniseries/Chapelwaite/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'ItNavigator':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/king/miniseries/It/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'LiseysStoryNavigator':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/king/miniseries/Liseys.Story/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'NadNavigator':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/king/miniseries/Stephen%20Kings%20-%20Nightmares%20And%20Dreamscapes/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'roseNavigator':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/king/miniseries/Stephen%20Kings%20Rose%20Red/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'sotcNavigator':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/king/miniseries/Storm%20Of%20The%20Century/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'outsiderNavigator':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/king/miniseries/The.Outsider/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'shiningNavigator':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/king/miniseries/The.Shining/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'thestandtwentyNavigator':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/king/miniseries/The.Stand.2020/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'tkNavigator':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/king/miniseries/The.Tommyknockers/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'mistNavigator':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/king/miniseries/The%20Mist/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'thestandNavigator':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/king/miniseries/The%20Stand/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')

elif action == 'movkingNavigator':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/king/movies/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')



elif action == "oneclicknav":
    from resources.lib.indexers import navigator
    navigator.navigator().ocsklicklibrary()