# -*- coding: utf-8 -*-

"""
    Frankenstein Add-on
    ///Updated for Frankenstein///

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""


import os,sys

import six

from resources.lib.modules import control
from resources.lib.modules import trakt
from resources.lib.modules import cache

sysaddon = sys.argv[0] ; syshandle = int(sys.argv[1])

artPath = control.artPath() ; addonFanart = control.addonFanart()

imdbCredentials = False if control.setting('imdb.user') == '' else True

traktCredentials = trakt.getTraktCredentialsInfo()

traktIndicators = trakt.getTraktIndicatorsInfo()

queueMenu = six.ensure_str(control.lang(32065))


class navigator:
    def root(self):
        self.addDirectoryItem('[COLOR ff90ee90]I will revenge my injuries if I cannot inspire love, I will cause fear.[/COLOR]', '', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem(32001, 'movieNavigator', 'movies.png', 'DefaultMovies.png')
        self.addDirectoryItem(32002, 'tvNavigator', 'tvshows.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32632, 'xmlsNavigator', 'playlist.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]Frankenstien 24/7 [/COLOR] [COLOR yellow]Warning May contain nudity[/COLOR]', 'frankenstienNavigator', 'playlist.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]24/7 Horror[/COLOR]', 'tfshNavigator', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Random Genre[/COLOR]', 'Randomnav', 'ran.png', 'DefaultMovies.png')
        self.addDirectoryItem(32633, '247nav', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32634, 'oneclickNavigator', 'oneclick.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]Usa And Ca Free Tv[/COLOR]', 'usandca', 'playlist.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]Uk And Unsorted Free Tv[/COLOR]', 'ukandunsorted', 'playlist.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]Foreign Free Tv[/COLOR]', 'foreign', 'playlist.png', 'DefaultTVShows.png')
        if not control.setting('lists.widget') == '0':
            self.addDirectoryItem(32003, 'mymovieNavigator', 'mymovies.png', 'DefaultVideoPlaylists.png')
            self.addDirectoryItem(32004, 'mytvNavigator', 'mytvshows.png', 'DefaultVideoPlaylists.png')

        if not control.setting('movie.widget') == '0':
            self.addDirectoryItem(32005, 'movieWidget', 'latest-movies.png', 'DefaultRecentlyAddedMovies.png')

        if (traktIndicators == True and not control.setting('tv.widget.alt') == '0') or (traktIndicators == False and not control.setting('tv.widget') == '0'):
            self.addDirectoryItem(32006, 'tvWidget', 'latest-episodes.png', 'DefaultRecentlyAddedEpisodes.png')

        if not control.setting('channels') == '0':
            self.addDirectoryItem(32007, 'channels', 'channels.png', 'DefaultMovies.png')

        if not control.setting('furk.api') == '':
            self.addDirectoryItem('[COLOR ff90ee90]Furk.net', 'furkNavigator', 'movies.png', 'movies.png')
        self.addDirectoryItem(32008, 'toolNavigator', 'tools.png', 'DefaultAddonProgram.png')

        downloads = True if control.setting('downloads') == 'true' and (len(control.listDir(control.setting('movie.download.path'))[0]) > 0 or len(control.listDir(control.setting('tv.download.path'))[0]) > 0) else False
        if downloads == True:
            self.addDirectoryItem(32009, 'downloadNavigator', 'downloads.png', 'DefaultFolder.png')

        self.addDirectoryItem(32010, 'searchNavigator', 'search.png', 'DefaultFolder.png')

        self.endDirectory()

    def furk(self):
        self.addDirectoryItem('[COLOR ff90ee90]User Files[/COLOR]', 'furkUserFiles', 'mytvnavigator.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Search[/COLOR]', 'furkSearch', 'search.png', 'search.png')
        self.endDirectory()

    def movies(self, lite=False):
        self.addDirectoryItem(32011, 'movieGenres', 'genres.png', 'DefaultMovies.png')
        self.addDirectoryItem(32012, 'movieYears', 'years.png', 'DefaultMovies.png')
        self.addDirectoryItem(32123, 'movieDecades', 'years.png', 'DefaultMovies.png')
        self.addDirectoryItem(32013, 'moviePersons', 'people.png', 'DefaultMovies.png')
        self.addDirectoryItem(32014, 'movieLanguages', 'languages.png', 'DefaultMovies.png')
        self.addDirectoryItem(32015, 'movieCertificates', 'certificates.png', 'DefaultMovies.png')
        self.addDirectoryItem(32017, 'movies&url=tmdb_popular', 'people-watching.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem(32018, 'movies&url=popular', 'most-popular.png', 'DefaultMovies.png')
        self.addDirectoryItem(32019, 'movies&url=views', 'most-voted.png', 'DefaultMovies.png')
        self.addDirectoryItem(32020, 'movies&url=boxoffice', 'box-office.png', 'DefaultMovies.png')
        self.addDirectoryItem(32021, 'movies&url=oscars', 'oscar-winners.png', 'DefaultMovies.png')
        self.addDirectoryItem(32022, 'movies&url=theaters', 'in-theaters.png', 'DefaultRecentlyAddedMovies.png')
        self.addDirectoryItem(32005, 'movieWidget', 'latest-movies.png', 'DefaultRecentlyAddedMovies.png')
        if lite == False:
            if not control.setting('lists.widget') == '0':
                self.addDirectoryItem(32003, 'mymovieliteNavigator', 'mymovies.png', 'DefaultVideoPlaylists.png')

            self.addDirectoryItem(32028, 'moviePerson', 'people-search.png', 'DefaultMovies.png')
            self.addDirectoryItem(32010, 'movieSearch', 'search.png', 'DefaultMovies.png')

        self.endDirectory()

    def xmls(self):
        self.addDirectoryItem('[COLOR ff90ee90]Wolfgirl[/COLOR]', 'wolfNavigator', 'playlist.png', 'DefaultTVShows.png')
        self.endDirectory()
        
    def oneclick(self):
        self.addDirectoryItem('[COLOR ff90ee90]These Are Hosted Indexes Some Might Take Longer To Load. Dont Click Me.[/COLOR]', '', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]Indexers 1[/COLOR]', 'lists2', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]Indexers 2[/COLOR]', 'lists3', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]Indexers 3[/COLOR]', 'extinfo', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]Indexers 4[/COLOR]', 'lists1', 'icon.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]All Horor Franchises[/COLOR]', 'lists4', 'playlist.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]Killer Bells[/COLOR]', 'lists5', 'playlist.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]All Movies[/COLOR]', 'lists6', 'icon.png', 'DefaultTVShows.png')
        
        self.endDirectory()
        
    def tfsh(self):
        self.addDirectoryItem('[COLOR ff90ee90]Wolves Littermates  24/7[/COLOR]', 'thepackNavigator', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]John Carpenter  24/7[/COLOR]', 'carpenter', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]Ginger Snaps 24/7[/COLOR]', 'ginger', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]Dracula 24/7[/COLOR]', 'dracula', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]Blade 24/7[/COLOR]', 'blade', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]Underworld 24/7[/COLOR]', 'underworld', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]24/7 Classic Horrors Nothing Above 1990[/COLOR]', 'classichr', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]Friday the 13th 24/7[/COLOR]', 'Friday', '247.png', 'DefaultTVShows.png')
        self.addDirectoryItem('[COLOR ff90ee90]Fright Night 24/7[/COLOR]', 'Fright', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Jaws 24/7[/COLOR]', 'Jaws', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Phantasm 24/7[/COLOR]', 'Phantasm', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]The Hills Have Eyes 24/7[/COLOR]', 'TheHills', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Candyman 24/7[/COLOR]', 'candyman', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Jeepers Creepers 24/7[/COLOR]', 'creepers', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]chucky 24/7[/COLOR]', 'chucky', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]The Lost Boys 24/7[/COLOR]', 'lostboys', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Nightmare On Elm St 24/7[/COLOR]', 'elm', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Evil Dead 24/7[/COLOR]', 'evil', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Halloween 24/7[/COLOR]', 'halloween', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Hellraiser 24/7[/COLOR]', 'hellraiser', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Joyride 24/7[/COLOR]', 'joyride', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Return Of The Living Dead 24/7[/COLOR]', 'living', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Rob Zombie 24/7[/COLOR]', 'robz', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]George Romero 24/7[/COLOR]', 'romero', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Texas ChainSaw 24/7[/COLOR]', 'texas', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Tales From The Crypt 24/7[/COLOR]', 'tftc', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]The blob 24/7[/COLOR]', 'theblob', '247.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Random Horror[/COLOR]', 'RandomHorror', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Kids Horror 24/7[/COLOR]', 'kidshr', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]24/7 American Horror Story[/COLOR] site 1', '247ahs', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]American Horror Story Site 2 24/7[/COLOR]', 'AmericanHorrorStory', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Creepshow 24/7[/COLOR]', 'Creepshow', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Elviras 40th Anniversary Very Scary Very Special Special S01 24/7[/COLOR]', 'Elviras40thAnniversaryVeryScaryVerySpecialSpecialS01', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Tales From The Crypt 24/7[/COLOR]', 'TalesFromTheCrypt', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Pumkinhead 24/7[/COLOR]', 'pheadNavigator', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Krampus 24/7[/COLOR]', 'krampusNavigator', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Killer Bells 24/7[/COLOR]', 'killerbellsNavigator', '247.png', 'mytvnavigator.png')
        self.endDirectory()
        
    def tfs(self):
        self.addDirectoryItem('[COLOR ff90ee90]EEK The Cat Courage The Cowardly Dog Darkwing Duck 24/7[/COLOR]', 'ecdd', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]24/7 Movies[/COLOR]', '247mov', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]24/7 Movies 2[/COLOR]', '247mov2', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]24/7 Movies 3[/COLOR]', '247mov3', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]24/7 Movies 4[/COLOR]', '247mov4', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]24/7 D.C Movies[/COLOR]', '247dcmov', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]24/7 Munsters[/COLOR]', '247munsters', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]24/7 Addams Family Tv Show[/COLOR]', '247addtv', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]24/7 Addams Family Movies[/COLOR]', '247addmov', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]24/7 Marvel Movies[/COLOR]', '247marmov', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]24/7 Oz[/COLOR]', '247oz', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]24/7 Peaky Blinders[/COLOR]', '247pb', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]24/7 Kids[/COLOR]', 'kids1', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]24/7 Kids  Spanish[/COLOR]', 'spanish', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]24/7 Toddler[/COLOR]', 'toddler', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Courage the Cowardly Dog[/COLOR]', 'CouragetheCowardlyDog', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Tales from the Cryptkeeper[/COLOR]', 'TalesfromtheCryptkeeper', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Chucky Tv Series 24/7[/COLOR]', 'chuckytv', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Marvels Hit Monkey 24/7[/COLOR]', 'MarvelsHitMonkey', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Mr. Bean 24/7 Section[/COLOR]', 'tfbeanNavigator', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]The Land Before Time 24/7[/COLOR]', 'tflbftNavigator', '247.png', 'mytvnavigator.png')
        self.endDirectory()
        
    def tfsmb(self):
        self.addDirectoryItem('[COLOR ff90ee90]The Complete Collection 24/7[/COLOR]', 'Mrbean1990', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Mr. Bean Animated Series Extras 24/7[/COLOR]', 'beananiextra', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Mr. Bean Animated Series 1 24/7[/COLOR]', 'beananiSeries1', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Mr. Bean Animated Series 2 24/7[/COLOR]', 'beananiSeries2', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Mr. Bean Animated Series 3 24/7[/COLOR]', 'beananiSeries3', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Mr. Bean Animated Series 4 24/7[/COLOR]', 'beananiSeries4', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Mr. Bean Animated Series 5 24/7[/COLOR]', 'beananiSeries5', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Mr. Bean Animated Series 6 24/7[/COLOR]', 'beananiSeries6', '247.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Rowan Atkinson Movies[/COLOR]', 'mrbeanmovies', '247.png', 'mytvnavigator.png')
        self.endDirectory()
        
    def Random(self):
        self.addDirectoryItem('[COLOR ff90ee90]Action[/COLOR]', 'RandomAction', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Adventure[/COLOR]', 'RandomAdventure', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Animation[/COLOR]', 'RandomAnimation', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Anime[/COLOR]', 'RandomAnime', 'ran.png', 'mytvnavigator.png'),
        self.addDirectoryItem('[COLOR ff90ee90]Biography[/COLOR]', 'RandomBiography', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Comedy[/COLOR]', 'RandomComedy', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Crime[/COLOR]', 'RandomCrime', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Documentary[/COLOR]', 'RandomDocumentary', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Drama[/COLOR]', 'RandomDrama', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Family[/COLOR]', 'RandomFamily', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Fantasy[/COLOR]', 'RandomFantasy', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]History[/COLOR]', 'RandomHistory', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Horror[/COLOR]', 'RandomHorror', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Music [/COLOR]', 'RandomMusic', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Musical[/COLOR]', 'RandomMusical', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Mystery[/COLOR]', 'RandomMystery', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Romance[/COLOR]', 'RandomRomance', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Science Fiction[/COLOR]', 'Randomsci_fi', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Sport[/COLOR]', 'RandomSport', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Thriller[/COLOR]', 'RandomThriller', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]War[/COLOR]', 'RandomWar', 'ran.png', 'mytvnavigator.png')
        self.addDirectoryItem('[COLOR ff90ee90]Western[/COLOR]', 'RandomWestern', 'ran.png', 'mytvnavigator.png')
        self.endDirectory()

    def wolf(self):
        self.addDirectoryItem('[COLOR ff90ee90]Action[/COLOR]', 'movies&url=wolfaction', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Comedy[/COLOR]', 'movies&url=wolfcomedy', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Monsters[/COLOR]', 'movies&url=wolfmonster', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Xmas[/COLOR]', 'movies&url=wolfxmas', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Apocolypse[/COLOR]', 'movies&url=wolfapoco', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Toons[/COLOR]', 'movies&url=wolftoon', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Docs[/COLOR]', 'movies&url=wolfdocs', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Vault[/COLOR]', 'movies&url=wolfvault', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Sleepy Hallow[/COLOR]', 'movies&url=wolfsleepy', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Paranormal[/COLOR]', 'movies&url=wolfpara', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]James Bond[/COLOR]', 'movies&url=wolfbond', 'icon.png', 'DefaultMovies.png')
        self.addDirectoryItem('[COLOR ff90ee90]Wolfs Picks[/COLOR]', 'movies&url=wolfpicks', 'icon.png', 'DefaultMovies.png')
        
        self.endDirectory()

    def usandca(self):
        self.addDirectoryItem('ca', 'rootca', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ca_samsung', 'rootca_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us', 'rootus', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_adultiptv', 'rootus_adultiptv', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_adultswim', 'rootus_adultswim', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_bumblebee', 'rootus_bumblebee', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_distro', 'rootus_distro', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_filmon', 'rootus_filmon', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_fubo', 'rootus_fubo', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_glewedtv', 'rootus_glewedtv', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_imdbtv', 'rootus_imdbtv', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_klowdtv', 'rootus_klowdtv', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_localnow', 'rootus_localnow', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_pbs', 'rootus_pbs', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_plex', 'rootus_plex', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_pluto', 'rootus_pluto', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_redbox', 'rootus_redbox', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_redtraffic', 'rootus_redtraffic', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_roku', 'rootus_roku', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_samsung', 'rootus_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_stirr', 'rootus_stirr', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_tcl', 'rootus_tcl', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_teleup', 'rootus_teleup', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_tubi', 'rootus_tubi', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_vizio', 'rootus_vizio', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('us_xumo', 'rootus_xumo', 'playlist.png', 'DefaultMovies.png')
        self.endDirectory()
        
    def ukandunsorted(self):
        self.addDirectoryItem('unsorted', 'rootunsorted', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('uk', 'rootuk', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('uk_samsung', 'rootuk_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('uk_sportstribal', 'rootuk_sportstribal', 'playlist.png', 'DefaultMovies.png')
        self.endDirectory()
        
    def foreign(self):
        self.addDirectoryItem('ad', 'rootad', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ae', 'rootae', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('af', 'rootaf', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ag', 'rootag', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('al', 'rootal', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('am', 'rootam', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ao', 'rootao', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ar', 'rootar', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('at', 'rootat', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('at_samsung', 'rootat_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('au', 'rootau', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('au_samsung', 'rootau_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('aw', 'rootaw', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('az', 'rootaz', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ba', 'rootba', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('bb', 'rootbb', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('bd', 'rootbd', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('be', 'rootbe', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('be_samsung', 'rootbe_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('bf', 'rootbf', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('bg', 'rootbg', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('bh', 'rootbh', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('bj', 'rootbj', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('bn', 'rootbn', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('bo', 'rootbo', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('br', 'rootbr', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('br_samsung', 'rootbr_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('bs', 'rootbs', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('by', 'rootby', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('cd', 'rootcd', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('cg', 'rootcg', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ch', 'rootch', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ch_samsung', 'rootch_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ci', 'rootci', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('cl', 'rootcl', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('cm', 'rootcm', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('cn', 'rootcn', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('co', 'rootco', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('cr', 'rootcr', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('cu', 'rootcu', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('cw', 'rootcw', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('cy', 'rootcy', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('cz', 'rootcz', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('de', 'rootde', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('de_samsung', 'rootde_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('dk', 'rootdk', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('dk_samsung', 'rootdk_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('do', 'rootdo', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('dz', 'rootdz', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ec', 'rootec', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ee', 'rootee', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('eg', 'rooteg', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('es', 'rootes', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('es_rakuten', 'rootes_rakuten', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('es_samsung', 'rootes_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('et', 'rootet', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('fi', 'rootfi', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('fi_samsung', 'rootfi_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('fj', 'rootfj', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('fo', 'rootfo', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('fr', 'rootfr', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('fr_samsung', 'rootfr_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ge', 'rootge', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('gh', 'rootgh', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('gl', 'rootgl', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('gm', 'rootgm', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('gn', 'rootgn', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('gp', 'rootgp', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('gq', 'rootgq', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('gr', 'rootgr', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('gt', 'rootgt', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('hk', 'roothk', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('hn', 'roothn', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('hr', 'roothr', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ht', 'rootht', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('hu', 'roothu', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('id', 'rootid', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ie', 'rootie', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ie_samsung', 'rootie_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('il', 'rootil', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('in', 'rootin', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('in_samsung', 'rootin_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('iq', 'rootiq', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ir', 'rootir', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('is', 'rootis', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('it', 'rootit', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('it_samsung', 'rootit_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('jm', 'rootjm', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('jo', 'rootjo', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('jp', 'rootjp', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ke', 'rootke', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('kg', 'rootkg', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('kh', 'rootkh', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('kp', 'rootkp', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('kr', 'rootkr', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('kw', 'rootkw', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('kz', 'rootkz', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('la', 'rootla', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('lb', 'rootlb', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('li', 'rootli', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('lk', 'rootlk', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('lt', 'rootlt', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('lu', 'rootlu', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('lu_samsung', 'rootlu_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('lv', 'rootlv', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ly', 'rootly', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ma', 'rootma', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('mc', 'rootmc', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('md', 'rootmd', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('me', 'rootme', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('mk', 'rootmk', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ml', 'rootml', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('mm', 'rootmm', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('mn', 'rootmn', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('mo', 'rootmo', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('mq', 'rootmq', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('mt', 'rootmt', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('mv', 'rootmv', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('mx', 'rootmx', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('mx_samsung', 'rootmx_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('my', 'rootmy', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('mz', 'rootmz', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ne', 'rootne', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ng', 'rootng', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ni', 'rootni', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('nl', 'rootnl', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('nl_samsung', 'rootnl_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('no', 'rootno', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('no_samsung', 'rootno_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('np', 'rootnp', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('nz', 'rootnz', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('om', 'rootom', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('pa', 'rootpa', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('pe', 'rootpe', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('pf', 'rootpf', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ph', 'rootph', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('pk', 'rootpk', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('pl', 'rootpl', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('pr', 'rootpr', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ps', 'rootps', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('pt', 'rootpt', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('pt_samsung', 'rootpt_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('py', 'rootpy', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('qa', 'rootqa', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ro', 'rootro', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('rs', 'rootrs', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ru', 'rootru', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ru_catcast', 'rootru_catcast', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('rw', 'rootrw', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('sa', 'rootsa', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('sd', 'rootsd', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('se', 'rootse', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('se_samsung', 'rootse_samsung', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('sg', 'rootsg', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('si', 'rootsi', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('sk', 'rootsk', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('sl', 'rootsl', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('sm', 'rootsm', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('sn', 'rootsn', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('so', 'rootso', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('sv', 'rootsv', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('sy', 'rootsy', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('th', 'rootth', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('tj', 'roottj', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('tm', 'roottm', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('tn', 'roottn', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('tr', 'roottr', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('tt', 'roottt', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('tw', 'roottw', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('tz', 'roottz', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ua', 'rootua', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ug', 'rootug', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('uy', 'rootuy', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('uz', 'rootuz', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('va', 'rootva', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ve', 'rootve', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('vn', 'rootvn', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('xk', 'rootxk', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('ye', 'rootye', 'playlist.png', 'DefaultMovies.png')
        self.addDirectoryItem('zm', 'rootzm', 'playlist.png', 'DefaultMovies.png')
        self.endDirectory()

    def mymovies(self, lite=False):
        self.accountCheck()

        if traktCredentials == True and imdbCredentials == True:
            self.addDirectoryItem(32094, 'movies&url=onDeck', 'trakt.png', 'DefaultMovies.png', queue=True)
            self.addDirectoryItem(32032, 'movies&url=traktcollection', 'trakt.png', 'DefaultMovies.png', queue=True, context=(32551, 'moviesToLibrary&url=traktcollection'))
            if control.setting('imdb.sort.order') == '1':
                self.addDirectoryItem(32034, 'movies&url=imdbwatchlist2', 'imdb.png', 'DefaultMovies.png', queue=True)
            else:
                self.addDirectoryItem(32034, 'movies&url=imdbwatchlist', 'imdb.png', 'DefaultMovies.png', queue=True)
            self.addDirectoryItem(32033, 'movies&url=traktwatchlist', 'trakt.png', 'DefaultMovies.png', queue=True, context=(32551, 'moviesToLibrary&url=traktwatchlist'))
            self.addDirectoryItem(32036, 'movies&url=trakthistory', 'trakt.png', 'DefaultMovies.png', queue=True)
            self.addDirectoryItem(32035, 'movies&url=traktfeatured', 'trakt.png', 'DefaultMovies.png', queue=True)

        elif traktCredentials == True:
            self.addDirectoryItem(32094, 'movies&url=onDeck', 'trakt.png', 'DefaultMovies.png', queue=True)
            self.addDirectoryItem(32032, 'movies&url=traktcollection', 'trakt.png', 'DefaultMovies.png', queue=True, context=(32551, 'moviesToLibrary&url=traktcollection'))
            self.addDirectoryItem(32033, 'movies&url=traktwatchlist', 'trakt.png', 'DefaultMovies.png', queue=True, context=(32551, 'moviesToLibrary&url=traktwatchlist'))
            self.addDirectoryItem(32036, 'movies&url=trakthistory', 'trakt.png', 'DefaultMovies.png', queue=True)
            self.addDirectoryItem(32035, 'movies&url=traktfeatured', 'trakt.png', 'DefaultMovies.png', queue=True)

        elif imdbCredentials == True:
            if control.setting('imdb.sort.order') == '1':
                self.addDirectoryItem(32034, 'movies&url=imdbwatchlist2', 'imdb.png', 'DefaultMovies.png', queue=True)
            else:
                self.addDirectoryItem(32034, 'movies&url=imdbwatchlist', 'imdb.png', 'DefaultMovies.png', queue=True)
            self.addDirectoryItem(32077, 'movies&url=featured', 'imdb.png', 'DefaultMovies.png', queue=True)

        self.addDirectoryItem(32039, 'movieUserlists', 'userlists.png', 'DefaultMovies.png')

        if lite == False:
            self.addDirectoryItem(32031, 'movieliteNavigator', 'movies.png', 'DefaultMovies.png')
            self.addDirectoryItem(32028, 'moviePerson', 'people-search.png', 'DefaultMovies.png')
            self.addDirectoryItem(32010, 'movieSearch', 'search.png', 'DefaultMovies.png')

        self.endDirectory()


    def tvshows(self, lite=False):
        self.addDirectoryItem(32011, 'tvGenres', 'genres.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32016, 'tvNetworks', 'networks.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32014, 'tvLanguages', 'languages.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32015, 'tvCertificates', 'certificates.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32017, 'tvshows&url=trending', 'people-watching.png', 'DefaultRecentlyAddedEpisodes.png')
        self.addDirectoryItem(32018, 'tvshows&url=popular', 'most-popular.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32023, 'tvshows&url=rating', 'highly-rated.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32019, 'tvshows&url=views', 'most-voted.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32024, 'tvshows&url=airing', 'airing-today.png', 'DefaultTVShows.png')
        #self.addDirectoryItem(32025, 'tvshows&url=active', 'returning-tvshows.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32026, 'tvshows&url=premiere', 'new-tvshows.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32006, 'calendar&url=added', 'latest-episodes.png', 'DefaultRecentlyAddedEpisodes.png', queue=True)
        self.addDirectoryItem(32027, 'calendars', 'calendar.png', 'DefaultRecentlyAddedEpisodes.png')

        if lite == False:
            if not control.setting('lists.widget') == '0':
                self.addDirectoryItem(32004, 'mytvliteNavigator', 'mytvshows.png', 'DefaultVideoPlaylists.png')

            self.addDirectoryItem(32028, 'tvPerson', 'people-search.png', 'DefaultTVShows.png')
            self.addDirectoryItem(32010, 'tvSearch', 'search.png', 'DefaultTVShows.png')

        self.endDirectory()


    def mytvshows(self, lite=False):
        try:
            self.accountCheck()

            if traktCredentials == True and imdbCredentials == True:

                self.addDirectoryItem(32094, 'calendar&url=onDeck', 'trakt.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32032, 'tvshows&url=traktcollection', 'trakt.png', 'DefaultTVShows.png', context=(32551, 'tvshowsToLibrary&url=traktcollection'))
                if control.setting('imdb.sort.order') == '1':
                    self.addDirectoryItem(32034, 'tvshows&url=imdbwatchlist2', 'imdb.png', 'DefaultTVShows.png')
                else:
                    self.addDirectoryItem(32034, 'tvshows&url=imdbwatchlist', 'imdb.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32033, 'tvshows&url=traktwatchlist', 'trakt.png', 'DefaultTVShows.png', context=(32551, 'tvshowsToLibrary&url=traktwatchlist'))
                self.addDirectoryItem(32035, 'tvshows&url=traktfeatured', 'trakt.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32036, 'calendar&url=trakthistory', 'trakt.png', 'DefaultTVShows.png', queue=True)
                self.addDirectoryItem(32037, 'calendar&url=progress', 'trakt.png', 'DefaultRecentlyAddedEpisodes.png', queue=True)
                self.addDirectoryItem(32038, 'calendar&url=mycalendar', 'trakt.png', 'DefaultRecentlyAddedEpisodes.png', queue=True)
                self.addDirectoryItem(32041, 'episodeUserlists', 'userlists.png', 'DefaultTVShows.png')

            elif traktCredentials == True:
                self.addDirectoryItem(32094, 'calendar&url=onDeck', 'trakt.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32032, 'tvshows&url=traktcollection', 'trakt.png', 'DefaultTVShows.png', context=(32551, 'tvshowsToLibrary&url=traktcollection'))
                self.addDirectoryItem(32033, 'tvshows&url=traktwatchlist', 'trakt.png', 'DefaultTVShows.png', context=(32551, 'tvshowsToLibrary&url=traktwatchlist'))
                self.addDirectoryItem(32035, 'tvshows&url=traktfeatured', 'trakt.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32036, 'calendar&url=trakthistory', 'trakt.png', 'DefaultTVShows.png', queue=True)
                self.addDirectoryItem(32037, 'calendar&url=progress', 'trakt.png', 'DefaultRecentlyAddedEpisodes.png', queue=True)
                self.addDirectoryItem(32038, 'calendar&url=mycalendar', 'trakt.png', 'DefaultRecentlyAddedEpisodes.png', queue=True)
                self.addDirectoryItem(32041, 'episodeUserlists', 'userlists.png', 'DefaultTVShows.png')

            elif imdbCredentials == True:
                if control.setting('imdb.sort.order') == '1':
                    self.addDirectoryItem(32034, 'tvshows&url=imdbwatchlist2', 'imdb.png', 'DefaultTVShows.png')
                else:
                    self.addDirectoryItem(32034, 'tvshows&url=imdbwatchlist', 'imdb.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32077, 'tvshows&url=trending', 'imdb.png', 'DefaultTVShows.png', queue=True)

            self.addDirectoryItem(32040, 'tvUserlists', 'userlists.png', 'DefaultTVShows.png')

            if lite == False:
                self.addDirectoryItem(32031, 'tvliteNavigator', 'tvshows.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32028, 'tvPerson', 'people-search.png', 'DefaultTVShows.png')
                self.addDirectoryItem(32010, 'tvSearch', 'search.png', 'DefaultTVShows.png')

            self.endDirectory()
        except:
            print("ERROR")

    def tools(self):
        self.addDirectoryItem('[B]Frankenstein[/B] : Changelog', 'changelog', 'tools.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32043, 'openSettings&query=0.0', 'tools.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32556, 'libraryNavigator', 'tools.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem(32049, 'viewsNavigator', 'tools.png', 'DefaultAddonProgram.png')
        self.addDirectoryItem(32604, 'clearCacheSearch', 'tools.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32050, 'clearSources', 'tools.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32116, 'clearDebridCheck', 'tools.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32052, 'clearCache', 'tools.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32611, 'clearAllCache', 'tools.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32108, 'cleanSettings', 'tools.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32079, 'WolfPackScrapersettings', 'icon.png', 'DefaultAddonProgram.png', isFolder=False)
        if not control.condVisibility('System.HasAddon(script.module.orion)'):
            self.addDirectoryItem('[B]Orion[/B] : Install', 'installOrion', 'orion.png', 'DefaultAddonProgram.png', isFolder=False)
        else:
            self.addDirectoryItem(32080, 'orionsettings', 'orion.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32076, 'smuSettings', 'resolveurl.png', 'DefaultAddonProgram.png', isFolder=False)
        if trakt.getTraktCredentialsInfo():
            self.addDirectoryItem(32093, 'syncTraktStatus', 'trakt.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32073, 'authTrakt', 'trakt.png', 'DefaultAddonProgram.png', isFolder=False)

        self.endDirectory()

    def library(self):
        self.addDirectoryItem(32557, 'openSettings&query=6.0', 'tools.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32558, 'updateLibrary&query=tool', 'library_update.png', 'DefaultAddonProgram.png', isFolder=False)
        self.addDirectoryItem(32559, control.setting('library.movie'), 'movies.png', 'DefaultMovies.png', isAction=False)
        self.addDirectoryItem(32560, control.setting('library.tv'), 'tvshows.png', 'DefaultTVShows.png', isAction=False)

        if trakt.getTraktCredentialsInfo():
            self.addDirectoryItem(32561, 'moviesToLibrary&url=traktcollection', 'trakt.png', 'DefaultMovies.png', isFolder=False)
            self.addDirectoryItem(32562, 'moviesToLibrary&url=traktwatchlist', 'trakt.png', 'DefaultMovies.png', isFolder=False)
            self.addDirectoryItem(32563, 'tvshowsToLibrary&url=traktcollection', 'trakt.png', 'DefaultTVShows.png', isFolder=False)
            self.addDirectoryItem(32564, 'tvshowsToLibrary&url=traktwatchlist', 'trakt.png', 'DefaultTVShows.png', isFolder=False)

        self.endDirectory()

    def downloads(self):
        movie_downloads = control.setting('movie.download.path')
        tv_downloads = control.setting('tv.download.path')

        if len(control.listDir(movie_downloads)[0]) > 0:
            self.addDirectoryItem(32001, movie_downloads, 'movies.png', 'DefaultMovies.png', isAction=False)
        if len(control.listDir(tv_downloads)[0]) > 0:
            self.addDirectoryItem(32002, tv_downloads, 'tvshows.png', 'DefaultTVShows.png', isAction=False)

        self.endDirectory()


    def search(self):
        self.addDirectoryItem(32001, 'movieSearch', 'search.png', 'DefaultMovies.png')
        self.addDirectoryItem(32002, 'tvSearch', 'search.png', 'DefaultTVShows.png')
        self.addDirectoryItem(32029, 'moviePerson', 'people-search.png', 'DefaultMovies.png')
        self.addDirectoryItem(32030, 'tvPerson', 'people-search.png', 'DefaultTVShows.png')

        self.endDirectory()

    def views(self):
        try:
            control.idle()

            items = [ (six.ensure_str(control.lang(32001)), 'movies'), (six.ensure_str(control.lang(32002)), 'tvshows'), (six.ensure_str(control.lang(32054)), 'seasons'), (six.ensure_str(control.lang(32038)), 'episodes') ]

            select = control.selectDialog([i[0] for i in items], six.ensure_str(control.lang(32049)))

            if select == -1: return

            content = items[select][1]

            title = six.ensure_str(control.lang(32059))
            url = '%s?action=addView&content=%s' % (sys.argv[0], content)

            poster, banner, fanart = control.addonPoster(), control.addonBanner(), control.addonFanart()

            item = control.item(label=title)
            item.setInfo(type='Video', infoLabels = {'title': title})
            item.setArt({'icon': poster, 'thumb': poster, 'poster': poster, 'banner': banner})
            item.setProperty('Fanart_Image', fanart)

            control.addItem(handle=int(sys.argv[1]), url=url, listitem=item, isFolder=False)
            control.content(int(sys.argv[1]), content)
            control.directory(int(sys.argv[1]), cacheToDisc=True)

            from resources.lib.modules import views
            views.setView(content, {})
        except:
            return


    def accountCheck(self):
        if traktCredentials == False and imdbCredentials == False:
            control.idle()
            control.infoDialog(six.ensure_str(control.lang(32042)), sound=True, icon='WARNING')
            sys.exit()


    def infoCheck(self, version):
        try:
            control.infoDialog('', six.ensure_str(control.lang(32074)), time=5000, sound=False)
            return '1'
        except:
            return '1'


    def clearCache(self):
        #control.idle()
        yes = control.yesnoDialog(control.lang(32056))
        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear()
        control.infoDialog(six.ensure_str(control.lang(32057)), sound=True, icon='INFO')

    def clearCacheMeta(self):
        #control.idle()
        yes = control.yesnoDialog(control.lang(32056))
        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear_meta()
        control.infoDialog(six.ensure_str(control.lang(32057)), sound=True, icon='INFO')

    def clearCacheProviders(self):
        #control.idle()
#        yes = control.yesnoDialog(control.lang(32056))
#        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear_providers()
        control.infoDialog(six.ensure_str(control.lang(32057)), sound=True, icon='INFO')

    def clearCacheSearch(self):
        #control.idle()
        yes = control.yesnoDialog(control.lang(32056))
        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear_search()
        control.infoDialog(six.ensure_str(control.lang(32057)), sound=True, icon='INFO')

    def clearDebridCheck(self):
        #control.idle()
        yes = control.yesnoDialog(control.lang(32056))
        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear_debrid()
        control.infoDialog(six.ensure_str(control.lang(32057)), sound=True, icon='INFO')

    def clearCacheAll(self):
        #control.idle()
        yes = control.yesnoDialog(control.lang(32056))
        if not yes: return
        from resources.lib.modules import cache
        cache.cache_clear_all()
        control.infoDialog(six.ensure_str(control.lang(32057)), sound=True, icon='INFO')

    def addDirectoryItem(self, name, query, thumb, icon, context=None, queue=False, isAction=True, isFolder=True):
        try: name = six.ensure_str(control.lang(name))
        except: pass
        url = '%s?action=%s' % (sysaddon, query) if isAction == True else query
        thumb = os.path.join(artPath, thumb) if not artPath == None else icon
        cm = []
        if queue == True: cm.append((queueMenu, 'RunPlugin(%s?action=queueItem)' % sysaddon))
        if not context == None: cm.append((six.ensure_str(control.lang(context[0])), 'RunPlugin(%s?action=%s)' % (sysaddon, context[1])))
        item = control.item(label=name)
        item.addContextMenuItems(cm)
        item.setArt({'icon': thumb, 'thumb': thumb})
        if not addonFanart == None: item.setProperty('Fanart_Image', addonFanart)
        control.addItem(handle=syshandle, url=url, listitem=item, isFolder=isFolder)

    def endDirectory(self, cache=True):
        control.content(syshandle, 'addons')
        control.directory(syshandle, cacheToDisc=cache)
