# -*- coding: utf-8 -*-

'''
    exodus Add-on

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''


import sys
from six.moves import urllib_parse
import xbmcgui

params = dict(urllib_parse.parse_qsl(sys.argv[2].replace('?','')))

action = params.get('action')

name = params.get('name')

title = params.get('title')

year = params.get('year')

imdb = params.get('imdb')

tvdb = params.get('tvdb')

tmdb = params.get('tmdb')

season = params.get('season')

episode = params.get('episode')

tvshowtitle = params.get('tvshowtitle')

premiered = params.get('premiered')

url = params.get('url')

image = params.get('image')

meta = params.get('meta')

select = params.get('select')

query = params.get('query')

source = params.get('source')

content = params.get('content')

windowedtrailer = params.get('windowedtrailer')
windowedtrailer = int(windowedtrailer) if windowedtrailer in ("0","1") else 0


if action == None:
    from resources.lib.indexers import navigator
    from resources.lib.modules import cache
    from resources.lib.modules import control
    cache.cache_version_check()
    if control.setting('startup.sync.trakt.status') == 'true':
        from resources.lib.modules import trakt
        trakt.syncTraktStatus()
    navigator.navigator().root()

elif action == "furkNavigator":
    from resources.lib.indexers import navigator
    navigator.navigator().furk()

elif action == "furkMetaSearch":
    from resources.lib.indexers import furk
    furk.furk().furk_meta_search(url)

elif action == "furkSearch":
    from resources.lib.indexers import furk
    furk.furk().search()

elif action == "furkUserFiles":
    from resources.lib.indexers import furk
    furk.furk().user_files()

elif action == "furkSearchNew":
    from resources.lib.indexers import furk
    furk.furk().search_new()

elif action == 'movieNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().movies()

elif action == 'movieliteNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().movies(lite=True)

elif action == 'mymovieNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().mymovies()

elif action == 'mymovieliteNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().mymovies(lite=True)

elif action == 'tvNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().tvshows()

elif action == 'tvliteNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().tvshows(lite=True)

elif action == 'mytvNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().mytvshows()

elif action == 'mytvliteNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().mytvshows(lite=True)

elif action == 'downloadNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().downloads()

elif action == 'libraryNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().library()

elif action == 'toolNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().tools()

elif action == 'searchNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().search()

elif action == 'viewsNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().views()

elif action == 'clearCache':
    from resources.lib.indexers import navigator
    navigator.navigator().clearCache()

elif action == 'clearCacheProviders':
    from resources.lib.indexers import navigator
    navigator.navigator().clearCacheProviders()

elif action == 'clearDebridCheck':
    from resources.lib.indexers import navigator
    navigator.navigator().clearDebridCheck()

elif action == 'clearCacheSearch':
    from resources.lib.indexers import navigator
    navigator.navigator().clearCacheSearch()

elif action == 'clearAllCache':
    from resources.lib.indexers import navigator
    navigator.navigator().clearCacheAll()

elif action == 'infoCheck':
    from resources.lib.indexers import navigator
    navigator.navigator().infoCheck('')

elif action == 'movies':
    from resources.lib.indexers import movies
    movies.movies().get(url)

elif action == 'moviePage':
    from resources.lib.indexers import movies
    movies.movies().get(url)

elif action == 'movieWidget':
    from resources.lib.indexers import movies
    movies.movies().widget()

elif action == 'movieSearch':
    from resources.lib.indexers import movies
    movies.movies().search()

elif action == 'movieSearchnew':
    from resources.lib.indexers import movies
    movies.movies().search_new()

elif action == 'movieSearchterm':
    from resources.lib.indexers import movies
    movies.movies().search_term(name)

elif action == 'moviePerson':
    from resources.lib.indexers import movies
    movies.movies().person()

elif action == 'movieGenres':
    from resources.lib.indexers import movies
    movies.movies().genres()

elif action == 'movieLanguages':
    from resources.lib.indexers import movies
    movies.movies().languages()

elif action == 'movieCertificates':
    from resources.lib.indexers import movies
    movies.movies().certifications()

elif action == 'movieYears':
    from resources.lib.indexers import movies
    movies.movies().years()

elif action == 'movieDecades':
    from resources.lib.indexers import movies
    movies.movies().decades()

elif action == 'moviePersons':
    from resources.lib.indexers import movies
    movies.movies().persons(url)

elif action == 'movieUserlists':
    from resources.lib.indexers import movies
    movies.movies().userlists()

elif action == 'channels':
    from resources.lib.indexers import channels
    channels.channels().get()

elif action == 'tvshows':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().get(url)

elif action == 'tvshowPage':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().get(url)

elif action == 'tvSearch':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().search()

elif action == 'tvSearchnew':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().search_new()

elif action == 'tvSearchterm':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().search_term(name)
    
elif action == 'tvPerson':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().person()

elif action == 'tvGenres':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().genres()

elif action == 'tvNetworks':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().networks()

elif action == 'tvLanguages':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().languages()

elif action == 'tvCertificates':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().certifications()

elif action == 'tvPersons':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().persons(url)

elif action == 'tvUserlists':
    from resources.lib.indexers import tvshows
    tvshows.tvshows().userlists()

elif action == 'seasons':
    from resources.lib.indexers import episodes
    episodes.seasons().get(tvshowtitle, year, imdb, tvdb)

elif action == 'episodes':
    from resources.lib.indexers import episodes
    episodes.episodes().get(tvshowtitle, year, imdb, tvdb, season, episode)

elif action == 'calendar':
    from resources.lib.indexers import episodes
    episodes.episodes().calendar(url)

elif action == 'tvWidget':
    from resources.lib.indexers import episodes
    episodes.episodes().widget()

elif action == 'calendars':
    from resources.lib.indexers import episodes
    episodes.episodes().calendars()

elif action == 'episodeUserlists':
    from resources.lib.indexers import episodes
    episodes.episodes().userlists()

elif action == 'refresh':
    from resources.lib.modules import control
    control.refresh()

elif action == 'queueItem':
    from resources.lib.modules import control
    control.queueItem()

elif action == 'openSettings':
    from resources.lib.modules import control
    control.openSettings(query)

elif action == 'artwork':
    from resources.lib.modules import control
    control.artwork()

elif action == 'addView':
    from resources.lib.modules import views
    views.addView(content)

elif action == 'moviePlaycount':
    from resources.lib.modules import playcount
    playcount.movies(imdb, query)

elif action == 'episodePlaycount':
    from resources.lib.modules import playcount
    playcount.episodes(imdb, tvdb, season, episode, query)

elif action == 'tvPlaycount':
    from resources.lib.modules import playcount
    playcount.tvshows(name, imdb, tvdb, season, query)

elif action == 'trailer':
    from resources.lib.modules import trailer
    trailer.trailer().play(name, url, windowedtrailer)

elif action == 'traktManager':
    from resources.lib.modules import trakt
    trakt.manager(name, imdb, tvdb, content)

elif action == 'authTrakt':
    from resources.lib.modules import trakt
    trakt.authTrakt()

elif action == 'smuSettings':
    try: import resolveurl
    except: pass
    resolveurl.display_settings()

elif action == 'WolfPackScrapersettings':
    from resources.lib.modules import control
    control.openSettings('0.0', 'script.module.wolfpackscrapers')

elif action == 'installWolf Pack Scrapers':
    from resources.lib.modules import control
    control.installAddon('script.module.exoscrapers')
    control.sleep(200)
    control.refresh()

elif action == 'openscrapersettings':
    from resources.lib.modules import control
    control.openSettings('0.0', 'script.module.exoscrapers')

elif action == 'installOrion':
    from resources.lib.modules import control
    control.installAddon('script.module.orion')
    control.sleep(200)
    control.refresh()

elif action == 'orionsettings':
    from resources.lib.modules import control
    control.openSettings('0.0', 'script.module.orion')

elif action == 'download':
    import simplejson as json
    from resources.lib.modules import sources
    from resources.lib.modules import downloader
    try: downloader.download(name, image, sources.sources().sourcesResolve(json.loads(source)[0], True))
    except: pass

elif action == 'play':
    from resources.lib.indexers import playlists
    if not content == None:
        playlists.player().play(url, content)
    else:
        from resources.lib.modules import sources
        sources.sources().play(title, year, imdb, tvdb, season,
                               episode, tvshowtitle, premiered, meta, select)
elif action == 'addItem':
    from resources.lib.modules import sources
    sources.sources().addItem(title)

elif action == 'playItem':
    from resources.lib.modules import sources
    sources.sources().playItem(title, source)

elif action == 'alterSources':
    from resources.lib.modules import sources
    sources.sources().alterSources(url, meta)

elif action == 'clearSources':
    from resources.lib.modules import sources
    sources.sources().clearSources()

elif action == 'random':
    rtype = params.get('rtype')
    if rtype == 'movie':
        from resources.lib.indexers import movies
        rlist = movies.movies().get(url, create_directory=False)
        r = sys.argv[0]+"?action=play"
    elif rtype == 'episode':
        from resources.lib.indexers import episodes
        rlist = episodes.episodes().get(tvshowtitle, year, imdb, tvdb, season, create_directory=False)
        r = sys.argv[0]+"?action=play"
    elif rtype == 'season':
        from resources.lib.indexers import episodes
        rlist = episodes.seasons().get(tvshowtitle, year, imdb, tvdb, create_directory=False)
        r = sys.argv[0]+"?action=random&rtype=episode"
    elif rtype == 'show':
        from resources.lib.indexers import tvshows
        rlist = tvshows.tvshows().get(url, create_directory=False)
        r = sys.argv[0]+"?action=random&rtype=season"
    from random import randint
    import simplejson as json
    try:
        from resources.lib.modules import control
        rand = randint(1,len(rlist))-1
        for p in ['title','year','imdb','tvdb','season','episode','tvshowtitle','premiered','select']:
            if rtype == "show" and p == "tvshowtitle":
                try: r += '&'+p+'='+urllib_parse.quote_plus(rlist[rand]['originaltitle'])
                except: pass
            else:
                if rtype == "movie":
                    rlist[rand]['title'] = rlist[rand]['originaltitle']
                elif rtype == "episode":
                    rlist[rand]['tvshowtitle'] = urllib_parse.unquote_plus(rlist[rand]['tvshowtitle'])
                try: r += '&'+p+'='+urllib_parse.quote_plus(rlist[rand][p])
                except: pass
        try: r += '&meta='+urllib_parse.quote_plus(json.dumps(rlist[rand]))
        except: r += '&meta={}'
        if rtype == "movie":
            try: control.infoDialog('%s (%s)' % (rlist[rand]['title'], rlist[rand]['year']), control.lang(32536), time=20000)
            except: pass
        elif rtype == "episode":
            try: control.infoDialog('%s - %01dx%02d . %s' % (urllib_parse.unquote_plus(rlist[rand]['tvshowtitle']), int(rlist[rand]['season']), int(rlist[rand]['episode']), rlist[rand]['title']), control.lang(32536), time=20000)
            except: pass
        control.execute('RunPlugin(%s)' % r)
    except:
        from resources.lib.modules import control
        control.infoDialog(control.lang(32537), time=8000)

elif action == 'movieToLibrary':
    from resources.lib.modules import libtools
    libtools.libmovies().add(name, title, year, imdb, tmdb)

elif action == 'moviesToLibrary':
    from resources.lib.modules import libtools
    libtools.libmovies().range(url)

elif action == 'moviesToLibrarySilent':
    from resources.lib.modules import libtools
    libtools.libmovies().silent(url)

elif action == 'tvshowToLibrary':
    from resources.lib.modules import libtools
    libtools.libtvshows().add(tvshowtitle, year, imdb, tvdb)

elif action == 'tvshowsToLibrary':
    from resources.lib.modules import libtools
    libtools.libtvshows().range(url)

elif action == 'tvshowsToLibrarySilent':
    from resources.lib.modules import libtools
    libtools.libtvshows().silent(url)

elif action == 'updateLibrary':
    from resources.lib.modules import libtools
    libtools.libepisodes().update(query)

elif action == 'service':
    from resources.lib.modules import libtools
    libtools.libepisodes().service()

elif action == 'syncTraktStatus':
    from resources.lib.modules import trakt
    trakt.syncTraktStatus()

elif action == 'changelog':
    from resources.lib.modules import changelog
    changelog.get()    

elif action == 'cleanSettings':
    from resources.lib.modules import control
    control.clean_settings()
##############################################################################################

elif action == 'xmlsNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().xmls()
    
elif action == 'oneclickNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().oneclick()
 
elif action == 'wolfNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().wolf()

elif action == 'magNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().playlists()
    
elif action == 'extinfo':
    from resources.lib.indexers import playlists
    playlists.indexer().rootextinfo()
    
elif action == 'lists1':
    from resources.lib.indexers import playlists
    playlists.indexer().rootlists1()
    
elif action == 'lists2':
    from resources.lib.indexers import playlists
    playlists.indexer().rootlists2()
    
elif action == 'lists3':
    from resources.lib.indexers import playlists
    playlists.indexer().rootlists3()
    
elif action == 'lists4':
    from resources.lib.indexers import playlists
    playlists.indexer().rootlists4()
    
elif action == 'lists5':
    from resources.lib.indexers import playlists
    playlists.indexer().rootlists5()
    
elif action == 'lists6':
    from resources.lib.indexers import playlists
    playlists.indexer().rootlists6()

elif action == 'directory':
    from resources.lib.indexers import playlists
    playlists.indexer().get(url)

elif action == 'qdirectory':
    from resources.lib.indexers import playlists
    playlists.indexer().getq(url)

elif action == 'xdirectory':
    from resources.lib.indexers import playlists
    playlists.indexer().getx(url)

elif action == 'developer':
    from resources.lib.indexers import playlists
    playlists.indexer().developer()

elif action == 'tvtuner':
    from resources.lib.indexers import playlists
    playlists.indexer().tvtuner(url)

elif 'youtube' in str(action):
    from resources.lib.indexers import playlists
    playlists.indexer().youtube(url, action)

elif action == 'browser':
    from resources.lib.indexers import playlists
    playlists.resolver().browser(url)

elif action == 'search':
    from resources.lib.indexers import playlists
    playlists.indexer().search()

elif action == 'addSearch':
    from resources.lib.indexers import playlists
    playlists.indexer().addSearch(url)

elif action == 'delSearch':
    from resources.lib.indexers import playlists
    playlists.indexer().delSearch()
    
elif action == 'ruSettings':
    from resources.lib.modules import control
    control.openSettings(id='script.module.resolveurl')

################################################247###############################################
    
elif action == "247nav":
    from resources.lib.indexers import navigator
    navigator.navigator().tfs()  

elif action == '247mov':
    xbmc.executebuiltin('PlayMedia(https://movies.encrypticmh.appboxes.co/247mov/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == '247mov2':
    xbmc.executebuiltin('PlayMedia(https://movies.encrypticmh.appboxes.co/247mov2/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == '247mov3':
    xbmc.executebuiltin('PlayMedia(https://movies.encrypticmh.appboxes.co/247mov3/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == '247mov4':
    xbmc.executebuiltin('PlayMedia(https://movies.encrypticmh.appboxes.co/247mov4/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == '247dcmov':
    xbmc.executebuiltin('PlayMedia(https://movies.encrypticmh.appboxes.co/dcmovies/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == '247marmov':
    xbmc.executebuiltin('PlayMedia(https://movies.encrypticmh.appboxes.co/marvel/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == '247addmov':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/addamsfam/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == '247addtv':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Addams%20Family%20(Complete%20TV%20series%20in%20MP4%20format)/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == '247munsters':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/The%20Munsters%20(Complete-Series)/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == '247oz':
    xbmc.executebuiltin('PlayMedia(https://repo.encrypticmh.appboxes.co/xml/oz.m3u)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == '247pb':
    xbmc.executebuiltin('PlayMedia(https://repo.encrypticmh.appboxes.co/xml/pb.m3u)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == '247ahs':
    xbmc.executebuiltin('PlayMedia(https://repo.encrypticmh.appboxes.co/xml/ahs.m3u)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'ecdd':
    xbmc.executebuiltin('PlayMedia(https://repo.encrypticmh.appboxes.co/xml/ecdd.m3u)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'toddler':
    xbmc.executebuiltin('PlayMedia(https://repo.encrypticmh.appboxes.co/xml/toddler.m3u)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'kids1':
    xbmc.executebuiltin('PlayMedia(https://repo.encrypticmh.appboxes.co/xml/kids.m3u)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'spanish':
    xbmc.executebuiltin('PlayMedia(https://repo.encrypticmh.appboxes.co/xml/span.m3u)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')

###################################################################################################
elif action == 'tfshNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().tfsh() 
 
elif action == 'Friday':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/Friday/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'creepers':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/creepers/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'FrightNight':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/Fright/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'Jaws':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/Jaws/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    

elif action == 'Phantasm':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/Phantasm/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    

elif action == 'TheHills':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/TheHills/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    

elif action == 'candyman':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/candyman/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    

elif action == 'chucky':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/chucky/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    

elif action == 'elm':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/elm/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    

elif action == 'evil':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/evil/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    

elif action == 'halloween':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/halloween/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    

elif action == 'hellraiser':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/hellraiser/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    

elif action == 'joyride':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/joyride/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'living':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/living/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'robz':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/robz/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'romero':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/romero/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'texas':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/texas/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    

elif action == 'tftc':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/tftc/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    

elif action == 'theblob':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/theblob/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')

elif action == 'lostboys':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/lostboys/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'CouragetheCowardlyDog':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/kids/Courage.the.Cowardly.Dog/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'TalesfromtheCryptkeeper':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/kids/Tales%20from%20the%20Cryptkeeper/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')

elif action == 'AmericanHorrorStory':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/American%20Horror%20Story/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'Creepshow':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/Creepshow/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'Elviras40thAnniversaryVeryScaryVerySpecialSpecialS01':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/Elviras.40th.Anniversary.Very.Scary.Very.Special.Special.S01.1080p.AMZN.WEBRip.DDP2.0.x264-WHOSNEXT%5beztv.re%5d/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'TalesFromTheCrypt':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/Tales.From.The.Crypt/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')

elif action == 'kidshr':
    xbmc.executebuiltin('PlayMedia(https://movies.encrypticmh.appboxes.co/kids/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'chuckytv':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/chucky/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
        
elif action == 'MarvelsHitMonkey':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/Marvels.Hit-Monkey.S01.1080p.HULU.WEBRip.DDP5.1.x264-TEPES%5brartv%5d/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')

elif action == 'tflbftNavigator':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/kids/The.Land.Before.Time.13.Movie.Collection.1988-2007.%5b2ch%5d%5bmp4%5d%5bRaven007%5d/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'pheadNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/pumpkinhead/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'krampusNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/krampus/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'killerbellsNavigator':
    xbmc.executebuiltin('PlayMedia(https://movies.encrypticmh.appboxes.co/killerbells/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'thepackNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/thepack/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'ginger':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/gingersnaps/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'classichr':
    xbmc.executebuiltin('PlayMedia(https://movies.encrypticmh.appboxes.co/247classichor/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'dracula':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/Dracula/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'blade':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/blade/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'underworld':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/Underworld/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'frankenstienNavigator':
    xbmc.executebuiltin('PlayMedia(https://franchises.encrypticmh.appboxes.co/frankenstien/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')

elif action == 'tfbeanNavigator':
    from resources.lib.indexers import navigator
    navigator.navigator().tfsmb()
    
elif action == 'beananiextra':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/mrbean/Mr.Bean%20Animated%20Series%20+%20Extra%20(Complete)%5bTeam%20Nanban%5d/Extra/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')

elif action == 'beananiSeries1':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/mrbean/Mr.Bean%20Animated%20Series%20+%20Extra%20(Complete)%5bTeam%20Nanban%5d/Series%201/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'beananiSeries2':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/mrbean/Mr.Bean%20Animated%20Series%20+%20Extra%20(Complete)%5bTeam%20Nanban%5d/Series%202/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'beananiSeries3':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/mrbean/Mr.Bean%20Animated%20Series%20+%20Extra%20(Complete)%5bTeam%20Nanban%5d/Series%203/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'beananiSeries4':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/mrbean/Mr.Bean%20Animated%20Series%20+%20Extra%20(Complete)%5bTeam%20Nanban%5d/Series%204/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'beananiSeries5':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/mrbean/Mr.Bean%20Animated%20Series%20+%20Extra%20(Complete)%5bTeam%20Nanban%5d/Series%205/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'beananiSeries6':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/mrbean/Mr.Bean%20Animated%20Series%20+%20Extra%20(Complete)%5bTeam%20Nanban%5d/Series%206/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'mrbeanmovies':
    xbmc.executebuiltin('PlayMedia(https://movies.encrypticmh.appboxes.co/bean/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'Mrbean1990':
    xbmc.executebuiltin('PlayMedia(https://tv.encrypticmh.appboxes.co/mrbean/Mr.%20Bean%20-%20The%20Complete%20Collection%20(1990-2007)/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
elif action == 'carpenter':
    xbmc.executebuiltin('PlayMedia(https://collections.encrypticmh.appboxes.co/carpenter/)')
    xbmc.executebuiltin('PlayerControl(repeatall)')
    xbmc.executebuiltin('PlayerControl(RandomOn)')
    
################################Random##############################################################\
    
elif action == "Randomnav":
    from resources.lib.indexers import navigator
    navigator.navigator().Random() 

elif action == "RandomAction":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=ranaction")')
    
elif action == "RandomAdventure":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=ranadventure")')
    
elif action == "RandomAnimation":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=rananimation")')
    
elif action == "RandomAnime":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=rananime")')
    
elif action == "RandomBiography":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=ranbiography")')
    
elif action == "RandomComedy":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=rancomedy")')
    
elif action == "RandomCrime":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=rancrime")')
    
elif action == "RandomDocumentary":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=randocumentary")')
    
elif action == "RandomDrama":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=randrama")')
    
elif action == "RandomFamily":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=ranfamily")')
    
elif action == "RandomFantasy":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=ranfantasy")')
    
    
elif action == "RandomHistory":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=ranhistory")')
    
elif action == "RandomHorror":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=ranhorror")')
    
elif action == "RandomMusic":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=ranmusic")')
    
elif action == "RandomMusical":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=ranmusical")')
    
elif action == "RandomMystery":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=ranmystery")')
    
elif action == "RandomRomance":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=ranromance")')
    
elif action == "Randomsci_fi":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=ransci_fi")')
    
elif action == "RandomSport":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=ransport")')
    
elif action == "RandomThriller":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=ranthriller")')
    
elif action == "RandomWar":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=ranwar")')
    
elif action == "RandomWestern":
    xbmc.executebuiltin('RunPlugin("plugin://plugin.video.frankenstein/?action=random&rtype=movie&url=ranwestern")')

##############################################################################################

elif action == 'foreign':
    from resources.lib.indexers import navigator
    navigator.navigator().foreign()

elif action == 'ukandunsorted':
    from resources.lib.indexers import navigator
    navigator.navigator().ukandunsorted()
    
elif action == 'usandca':
    from resources.lib.indexers import navigator
    navigator.navigator().usandca()
    
    
elif action == 'rootuk':
    from resources.lib.indexers import playlists
    playlists.indexer().rootuk()
    
elif action == 'rootuk_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootuk_samsung()
    
elif action == 'rootuk_sportstribal':
    from resources.lib.indexers import playlists
    playlists.indexer().rootuk_sportstribal()

elif action == 'rootca':
    from resources.lib.indexers import playlists
    playlists.indexer().rootca()

elif action == 'rootca_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootca_samsung()

elif action == 'rootus':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus()

elif action == 'rootus_adultiptv':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_adultiptv()

elif action == 'rootus_adultswim':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_adultswim()

elif action == 'rootus_bumblebee':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_bumblebee()

elif action == 'rootus_distro':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_distro()

elif action == 'rootus_filmon':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_filmon()

elif action == 'rootus_fubo':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_fubo()

elif action == 'rootus_glewedtv':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_glewedtv()

elif action == 'rootus_imdbtv':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_imdbtv()
    
elif action == 'rootus_klowdtv':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_klowdtv()
    
elif action == 'rootus_localnow':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_localnow()
    
elif action == 'rootus_pbs':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_pbs()
    
elif action == 'rootus_plex':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_plex()
    
elif action == 'rootus_pluto':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_pluto()
    
elif action == 'rootus_redbox':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_redbox()
    
elif action == 'rootus_redtraffic':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_redtraffic()
    
elif action == 'rootus_roku':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_roku()
    
elif action == 'rootus_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_samsung()
    
elif action == 'rootus_stirr':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_stirr()
    
elif action == 'rootus_tcl':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_tcl()
    
elif action == 'rootus_teleup':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_teleup()
    
elif action == 'rootus_tubi':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_tubi()
    
elif action == 'rootus_vizio':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_vizio()
    
elif action == 'rootus_xumo':
    from resources.lib.indexers import playlists
    playlists.indexer().rootus_xumo()

elif action == 'rootad':
    from resources.lib.indexers import playlists
    playlists.indexer().rootad()
    
elif action == 'rootae':
    from resources.lib.indexers import playlists
    playlists.indexer().rootae()
    
elif action == 'rootaf':
    from resources.lib.indexers import playlists
    playlists.indexer().rootaf()
    
elif action == 'rootag':
    from resources.lib.indexers import playlists
    playlists.indexer().rootag()
    
elif action == 'rootal':
    from resources.lib.indexers import playlists
    playlists.indexer().rootal()
    
elif action == 'rootam':
    from resources.lib.indexers import playlists
    playlists.indexer().rootam()
    
elif action == 'rootao':
    from resources.lib.indexers import playlists
    playlists.indexer().rootao()
    
elif action == 'rootar':
    from resources.lib.indexers import playlists
    playlists.indexer().rootar()
    
elif action == 'rootat':
    from resources.lib.indexers import playlists
    playlists.indexer().rootat()
    
elif action == 'rootat_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootat_samsung()
    
elif action == 'rootau':
    from resources.lib.indexers import playlists
    playlists.indexer().rootau()
    
elif action == 'rootau_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootau_samsung()
    
elif action == 'rootaw':
    from resources.lib.indexers import playlists
    playlists.indexer().rootaw()
    
elif action == 'rootaz':
    from resources.lib.indexers import playlists
    playlists.indexer().rootaz()
    
elif action == 'rootba':
    from resources.lib.indexers import playlists
    playlists.indexer().rootba()
    
elif action == 'rootbb':
    from resources.lib.indexers import playlists
    playlists.indexer().rootbb()
    
elif action == 'rootbd':
    from resources.lib.indexers import playlists
    playlists.indexer().rootbd()
    
elif action == 'rootbe':
    from resources.lib.indexers import playlists
    playlists.indexer().rootbe()
    
elif action == 'rootbe_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootbe_samsung()
elif action == 'rootbf':
    from resources.lib.indexers import playlists
    playlists.indexer().rootbf()
    
elif action == 'rootbg':
    from resources.lib.indexers import playlists
    playlists.indexer().rootbg()
    
elif action == 'rootbh':
    from resources.lib.indexers import playlists
    playlists.indexer().rootbh()
    
elif action == 'rootbj':
    from resources.lib.indexers import playlists
    playlists.indexer().rootbj()
    
elif action == 'rootbn':
    from resources.lib.indexers import playlists
    playlists.indexer().rootbn()

elif action == 'rootbo':
    from resources.lib.indexers import playlists
    playlists.indexer().rootbo()

elif action == 'rootbr':
    from resources.lib.indexers import playlists
    playlists.indexer().rootbr()

elif action == 'rootbr_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootbr_samsung()

elif action == 'rootbs':
    from resources.lib.indexers import playlists
    playlists.indexer().rootbs()

elif action == 'rootby':
    from resources.lib.indexers import playlists
    playlists.indexer().rootby()

elif action == 'rootcd':
    from resources.lib.indexers import playlists
    playlists.indexer().rootcd()

elif action == 'rootcg':
    from resources.lib.indexers import playlists
    playlists.indexer().rootcg()

elif action == 'rootch':
    from resources.lib.indexers import playlists
    playlists.indexer().rootch()

elif action == 'rootch_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootch_samsung()

elif action == 'rootci':
    from resources.lib.indexers import playlists
    playlists.indexer().rootci()

elif action == 'rootcl':
    from resources.lib.indexers import playlists
    playlists.indexer().rootcl()

elif action == 'rootcm':
    from resources.lib.indexers import playlists
    playlists.indexer().rootcm()

elif action == 'rootcn':
    from resources.lib.indexers import playlists
    playlists.indexer().rootcn()

elif action == 'rootco':
    from resources.lib.indexers import playlists
    playlists.indexer().rootco()

elif action == 'rootcr':
    from resources.lib.indexers import playlists
    playlists.indexer().rootcr()

elif action == 'rootcu':
    from resources.lib.indexers import playlists
    playlists.indexer().rootcu()
elif action == 'rootcw':
    from resources.lib.indexers import playlists
    playlists.indexer().rootcw()

elif action == 'rootcy':
    from resources.lib.indexers import playlists
    playlists.indexer().rootcy()

elif action == 'rootcz':
    from resources.lib.indexers import playlists
    playlists.indexer().rootcz()

elif action == 'rootde':
    from resources.lib.indexers import playlists
    playlists.indexer().rootde()

elif action == 'rootde_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootde_samsung()

elif action == 'rootdk':
    from resources.lib.indexers import playlists
    playlists.indexer().rootdk()

elif action == 'rootdk_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootdk_samsung()

elif action == 'rootdo':
    from resources.lib.indexers import playlists
    playlists.indexer().rootdo()

elif action == 'rootdz':
    from resources.lib.indexers import playlists
    playlists.indexer().rootdz()

elif action == 'rootec':
    from resources.lib.indexers import playlists
    playlists.indexer().rootec()

elif action == 'rootee':
    from resources.lib.indexers import playlists
    playlists.indexer().rootee()

elif action == 'rooteg':
    from resources.lib.indexers import playlists
    playlists.indexer().rooteg()

elif action == 'rootes':
    from resources.lib.indexers import playlists
    playlists.indexer().rootes()

elif action == 'rootes_rakuten':
    from resources.lib.indexers import playlists
    playlists.indexer().rootes_rakuten()

elif action == 'rootes_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootes_samsung()

elif action == 'rootet':
    from resources.lib.indexers import playlists
    playlists.indexer().rootet()

elif action == 'rootfi':
    from resources.lib.indexers import playlists
    playlists.indexer().rootfi()

elif action == 'rootfi_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootfi_samsung()

elif action == 'rootfj':
    from resources.lib.indexers import playlists
    playlists.indexer().rootfj()

elif action == 'rootfo':
    from resources.lib.indexers import playlists
    playlists.indexer().rootfo()
elif action == 'rootfr':
    from resources.lib.indexers import playlists
    playlists.indexer().rootfr()

elif action == 'rootfr_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootfr_samsung()

elif action == 'rootge':
    from resources.lib.indexers import playlists
    playlists.indexer().rootge()

elif action == 'rootgh':
    from resources.lib.indexers import playlists
    playlists.indexer().rootgh()

elif action == 'rootgl':
    from resources.lib.indexers import playlists
    playlists.indexer().rootgl()

elif action == 'rootgm':
    from resources.lib.indexers import playlists
    playlists.indexer().rootgm()

elif action == 'rootgn':
    from resources.lib.indexers import playlists
    playlists.indexer().rootgn()

elif action == 'rootgp':
    from resources.lib.indexers import playlists
    playlists.indexer().rootgp()

elif action == 'rootgq':
    from resources.lib.indexers import playlists
    playlists.indexer().rootgq()

elif action == 'rootgr':
    from resources.lib.indexers import playlists
    playlists.indexer().rootgr()

elif action == 'rootgt':
    from resources.lib.indexers import playlists
    playlists.indexer().rootgt()

elif action == 'roothk':
    from resources.lib.indexers import playlists
    playlists.indexer().roothk()

elif action == 'roothn':
    from resources.lib.indexers import playlists
    playlists.indexer().roothn()

elif action == 'roothr':
    from resources.lib.indexers import playlists
    playlists.indexer().roothr()

elif action == 'rootht':
    from resources.lib.indexers import playlists
    playlists.indexer().rootht()

elif action == 'roothu':
    from resources.lib.indexers import playlists
    playlists.indexer().roothu()

elif action == 'rootid':
    from resources.lib.indexers import playlists
    playlists.indexer().rootid()

elif action == 'rootie':
    from resources.lib.indexers import playlists
    playlists.indexer().rootie()

elif action == 'rootie_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootie_samsung()

elif action == 'rootil':
    from resources.lib.indexers import playlists
    playlists.indexer().rootil()

elif action == 'rootin':
    from resources.lib.indexers import playlists
    playlists.indexer().rootin()

elif action == 'rootin_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootin_samsung()

elif action == 'rootiq':
    from resources.lib.indexers import playlists
    playlists.indexer().rootiq()

elif action == 'rootir':
    from resources.lib.indexers import playlists
    playlists.indexer().rootir()

elif action == 'rootis':
    from resources.lib.indexers import playlists
    playlists.indexer().rootis()

elif action == 'rootit':
    from resources.lib.indexers import playlists
    playlists.indexer().rootit()

elif action == 'rootit_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootit_samsung()

elif action == 'rootjm':
    from resources.lib.indexers import playlists
    playlists.indexer().rootjm()

elif action == 'rootjo':
    from resources.lib.indexers import playlists
    playlists.indexer().rootjo()

elif action == 'rootjp':
    from resources.lib.indexers import playlists
    playlists.indexer().rootjp()

elif action == 'rootke':
    from resources.lib.indexers import playlists
    playlists.indexer().rootke()

elif action == 'rootkg':
    from resources.lib.indexers import playlists
    playlists.indexer().rootkg()

elif action == 'rootkh':
    from resources.lib.indexers import playlists
    playlists.indexer().rootkh()

elif action == 'rootkp':
    from resources.lib.indexers import playlists
    playlists.indexer().rootkp()

elif action == 'rootkr':
    from resources.lib.indexers import playlists
    playlists.indexer().rootkr()

elif action == 'rootkw':
    from resources.lib.indexers import playlists
    playlists.indexer().rootkw()

elif action == 'rootkz':
    from resources.lib.indexers import playlists
    playlists.indexer().rootkz()

elif action == 'rootla':
    from resources.lib.indexers import playlists
    playlists.indexer().rootla()

elif action == 'rootlb':
    from resources.lib.indexers import playlists
    playlists.indexer().rootlb()

elif action == 'rootli':
    from resources.lib.indexers import playlists
    playlists.indexer().rootli()

elif action == 'rootlk':
    from resources.lib.indexers import playlists
    playlists.indexer().rootlk()

elif action == 'rootlt':
    from resources.lib.indexers import playlists
    playlists.indexer().rootlt()

elif action == 'rootlu':
    from resources.lib.indexers import playlists
    playlists.indexer().rootlu()

elif action == 'rootlu_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootlu_samsung()

elif action == 'rootlv':
    from resources.lib.indexers import playlists
    playlists.indexer().rootlv()

elif action == 'rootly':
    from resources.lib.indexers import playlists
    playlists.indexer().rootly()

elif action == 'rootma':
    from resources.lib.indexers import playlists
    playlists.indexer().rootma()

elif action == 'rootmc':
    from resources.lib.indexers import playlists
    playlists.indexer().rootmc()

elif action == 'rootmd':
    from resources.lib.indexers import playlists
    playlists.indexer().rootmd()

elif action == 'rootme':
    from resources.lib.indexers import playlists
    playlists.indexer().rootme()

elif action == 'rootmk':
    from resources.lib.indexers import playlists
    playlists.indexer().rootmk()

elif action == 'rootml':
    from resources.lib.indexers import playlists
    playlists.indexer().rootml()

elif action == 'rootmm':
    from resources.lib.indexers import playlists
    playlists.indexer().rootmm()

elif action == 'rootmn':
    from resources.lib.indexers import playlists
    playlists.indexer().rootmn()

elif action == 'rootmo':
    from resources.lib.indexers import playlists
    playlists.indexer().rootmo()

elif action == 'rootmq':
    from resources.lib.indexers import playlists
    playlists.indexer().rootmq()

elif action == 'rootmt':
    from resources.lib.indexers import playlists
    playlists.indexer().rootmt()

elif action == 'rootmv':
    from resources.lib.indexers import playlists
    playlists.indexer().rootmv()

elif action == 'rootmx':
    from resources.lib.indexers import playlists
    playlists.indexer().rootmx()

elif action == 'rootmx_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootmx_samsung()

elif action == 'rootmy':
    from resources.lib.indexers import playlists
    playlists.indexer().rootmy()

elif action == 'rootmz':
    from resources.lib.indexers import playlists
    playlists.indexer().rootmz()

elif action == 'rootne':
    from resources.lib.indexers import playlists
    playlists.indexer().rootne()

elif action == 'rootng':
    from resources.lib.indexers import playlists
    playlists.indexer().rootng()

elif action == 'rootni':
    from resources.lib.indexers import playlists
    playlists.indexer().rootni()

elif action == 'rootnl':
    from resources.lib.indexers import playlists
    playlists.indexer().rootnl()

elif action == 'rootnl_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootnl_samsung()

elif action == 'rootno':
    from resources.lib.indexers import playlists
    playlists.indexer().rootno()

elif action == 'rootno_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootno_samsung()

elif action == 'rootnp':
    from resources.lib.indexers import playlists
    playlists.indexer().rootnp()

elif action == 'rootnz':
    from resources.lib.indexers import playlists
    playlists.indexer().rootnz()

elif action == 'rootom':
    from resources.lib.indexers import playlists
    playlists.indexer().rootom()

elif action == 'rootpa':
    from resources.lib.indexers import playlists
    playlists.indexer().rootpa()

elif action == 'rootpe':
    from resources.lib.indexers import playlists
    playlists.indexer().rootpe()

elif action == 'rootpf':
    from resources.lib.indexers import playlists
    playlists.indexer().rootpf()

elif action == 'rootph':
    from resources.lib.indexers import playlists
    playlists.indexer().rootph()

elif action == 'rootpk':
    from resources.lib.indexers import playlists
    playlists.indexer().rootpk()

elif action == 'rootpl':
    from resources.lib.indexers import playlists
    playlists.indexer().rootpl()

elif action == 'rootpr':
    from resources.lib.indexers import playlists
    playlists.indexer().rootpr()

elif action == 'rootps':
    from resources.lib.indexers import playlists
    playlists.indexer().rootps()

elif action == 'rootpt':
    from resources.lib.indexers import playlists
    playlists.indexer().rootpt()

elif action == 'rootpt_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootpt_samsung()

elif action == 'rootpy':
    from resources.lib.indexers import playlists
    playlists.indexer().rootpy()

elif action == 'rootqa':
    from resources.lib.indexers import playlists
    playlists.indexer().rootqa()

elif action == 'rootro':
    from resources.lib.indexers import playlists
    playlists.indexer().rootro()

elif action == 'rootrs':
    from resources.lib.indexers import playlists
    playlists.indexer().rootrs()

elif action == 'rootru':
    from resources.lib.indexers import playlists
    playlists.indexer().rootru()

elif action == 'rootru_catcast':
    from resources.lib.indexers import playlists
    playlists.indexer().rootru_catcast()

elif action == 'rootrw':
    from resources.lib.indexers import playlists
    playlists.indexer().rootrw()

elif action == 'rootsa':
    from resources.lib.indexers import playlists
    playlists.indexer().rootsa()

elif action == 'rootsd':
    from resources.lib.indexers import playlists
    playlists.indexer().rootsd()

elif action == 'rootse':
    from resources.lib.indexers import playlists
    playlists.indexer().rootse()

elif action == 'rootse_samsung':
    from resources.lib.indexers import playlists
    playlists.indexer().rootse_samsung()

elif action == 'rootsg':
    from resources.lib.indexers import playlists
    playlists.indexer().rootsg()

elif action == 'rootsi':
    from resources.lib.indexers import playlists
    playlists.indexer().rootsi()

elif action == 'rootsk':
    from resources.lib.indexers import playlists
    playlists.indexer().rootsk()

elif action == 'rootsl':
    from resources.lib.indexers import playlists
    playlists.indexer().rootsl()

elif action == 'rootsm':
    from resources.lib.indexers import playlists
    playlists.indexer().rootsm()

elif action == 'rootsn':
    from resources.lib.indexers import playlists
    playlists.indexer().rootsn()

elif action == 'rootso':
    from resources.lib.indexers import playlists
    playlists.indexer().rootso()

elif action == 'rootsv':
    from resources.lib.indexers import playlists
    playlists.indexer().rootsv()

elif action == 'rootsy':
    from resources.lib.indexers import playlists
    playlists.indexer().rootsy()

elif action == 'rootth':
    from resources.lib.indexers import playlists
    playlists.indexer().rootth()

elif action == 'roottj':
    from resources.lib.indexers import playlists
    playlists.indexer().roottj()

elif action == 'roottm':
    from resources.lib.indexers import playlists
    playlists.indexer().roottm()

elif action == 'roottn':
    from resources.lib.indexers import playlists
    playlists.indexer().roottn()

elif action == 'roottr':
    from resources.lib.indexers import playlists
    playlists.indexer().roottr()

elif action == 'roottt':
    from resources.lib.indexers import playlists
    playlists.indexer().roottt()

elif action == 'roottw':
    from resources.lib.indexers import playlists
    playlists.indexer().roottw()

elif action == 'roottz':
    from resources.lib.indexers import playlists
    playlists.indexer().roottz()

elif action == 'rootua':
    from resources.lib.indexers import playlists
    playlists.indexer().rootua()

elif action == 'rootug':
    from resources.lib.indexers import playlists
    playlists.indexer().rootug()

elif action == 'rootuy':
    from resources.lib.indexers import playlists
    playlists.indexer().rootuy()

elif action == 'rootuz':
    from resources.lib.indexers import playlists
    playlists.indexer().rootuz()

elif action == 'rootva':
    from resources.lib.indexers import playlists
    playlists.indexer().rootva()

elif action == 'rootve':
    from resources.lib.indexers import playlists
    playlists.indexer().rootve()

elif action == 'rootvn':
    from resources.lib.indexers import playlists
    playlists.indexer().rootvn()

elif action == 'rootxk':
    from resources.lib.indexers import playlists
    playlists.indexer().rootxk()

elif action == 'rootye':
    from resources.lib.indexers import playlists
    playlists.indexer().rootye()

elif action == 'rootzm':
    from resources.lib.indexers import playlists
    playlists.indexer().rootzm()