###########################################
#     GIVE CREDIT WHERE CREDIT IS DUE     #
#                                         #
#          T4ILS AND JETJET               #
###########################################




import json, sys, os
import threading
from ..util.dialogs import link_dialog, remove_name
from xbmcvfs import translatePath
from concurrent.futures import ThreadPoolExecutor
import xbmc, xbmcaddon, xbmcgui, xbmcplugin
from resources.lib.plugin import Plugin
from datetime import datetime, timedelta
import calendar, inputstreamhelper
from jetextractors import extractor as jet_extractor
from jetextractors import config as jet_config
from jetextractors.models import *
from resources.lib.plugin import run_hook
import urllib.parse
import resolveurl


DEFAULT_DISABLED = ["Full Match TV",
                    "Topstreams",
                    "Buffstreams",
                    "Sling",
                    "USTVGO",
                    "Yahoo Sports",
                    "Yahoo Sports - MLB Highlights",
                    "Yahoo Sports - NBA Highlights",
                    "Yahoo Sports - NCAAB Highlights",
                    "Yahoo Sports - NHL Highlights",
                    "Freefeds",
                    "Direct_CH"]


class jetextractors(Plugin):
    name = "sportjetextractors"
    priority = 100


    def process_item(self, item):
        if self.name in item:
            link = item.get(self.name, "")
            thumbnail = item.get("thumbnail", "")
            fanart = item.get("fanart", "")
            icon = item.get("icon", "")
            if not isinstance(link, list):
                if link.startswith("http"):
                    item["is_dir"] = False
                    item["link"] = "/play_video/" + urllib.parse.quote_plus(json.dumps(item))
                elif link == "extractor_settings":
                    item["is_dir"] = False
                    item["link"] = f"{self.name}/extractor_settings"
                elif link == "iptv_setup":
                    item["is_dir"] = False
                    item["link"] = f"{self.name}/iptv_setup"
                elif link == "sites":
                    item["is_dir"] = True
                    item["link"] = f"{self.name}/sites"
                elif link == "dialog":
                    item["is_dir"] = False
                    item["link"] = f"{self.name}/dialog"
                elif link == "clear_config":
                    item["is_dir"] = False
                    item["link"] = f"{self.name}/clear_config"
                elif link == "set_uuid":
                    item["is_dir"] = False
                    item["link"] = f"{self.name}/set_uuid"
                else:
                    item["link"] = f"{self.name}/games/" + link if "search" not in link else f"{self.name}/" + link
                    item["is_dir"] = True
                
                list_item = xbmcgui.ListItem(item.get("title", item.get("name", "")), offscreen=True)
                list_item.setArt({"thumb": thumbnail, "fanart": fanart})
                item["list_item"] = list_item
                return item
    

    def play_video(self, video: str):
        item = json.loads(video)
        link = item.get(self.name)
        if link is None:
            temp_link = item.get('link')
            if temp_link is not None and 'jetextractors' in temp_link:
                link = temp_link.split('play?urls=')[-1]
        title = item.get("title")
        thumbnail = item.get("thumbnail", "")

        if not link:
            return False
        
        # Parse JetLink from json
        jet_link: JetLink = None
        if type(link) == str and link.startswith("{"):
            link = json.loads(link.address)

        if isinstance(link, list):
            if len(link) == 0:
                xbmcgui.Dialog().notification("Jetextractors error", "No links specified.", icon=xbmcgui.NOTIFICATION_WARNING, time=3000)
                return True
            
            links: list[JetLink] = [JetLink(l) if type(l) == str else JetLink.from_dict(l) for l in link]
            link_idx = link_dialog([l.address + (f"({l.name})" if l.name is not None else "") for l in links], return_idx=True)  
            if link_idx is None:
                return True
            jet_link = links[link_idx]
        elif isinstance(link, dict):
            jet_link = JetLink.from_dict(link)
        elif type(link) == str:
            jet_link = JetLink(link)

        if jet_link is None: # This should not happen
            xbmcgui.Dialog().notification("Jetextractors error", "Malformed link.", icon=xbmcgui.NOTIFICATION_WARNING, time=3000)
            return True
        
        if jet_link.address.startswith("links://"):
            jet_link.links = True
            jet_link.address = jet_link.address.replace("links://", "")
        while jet_link.links:
            e = jet_extractor.find_extractor(jet_link)
            links = e.get_links(jet_link)
            link_idx = link_dialog([l.address + (f"({l.name})" if l.name is not None else "") for l in links], return_idx=True)
            if link_idx is None:
                return True
            jet_link = links[link_idx]
        
        if jet_link.unquote:
            jet_link.address = urllib.parse.unquote(jet_link.address)
        
        if jet_link.address.startswith("plugin://"):
            xbmc.executebuiltin(f"RunPlugin({jet_link.address})")
            return True
        if jet_link.address.startswith("direct://"):
            jet_link.address = jet_link.address.replace("direct://", "")
            jet_link.direct = True
        if jet_link.address.startswith("ffmpegdirect://"):
            jet_link.address = jet_link.address.replace("ffmpegdirect://", "")
            jet_link.inputstream = JetInputstreamFFmpegDirect.default()
        if jet_link.address.startswith("jetproxy://"):
            jet_link.address = jet_link.address.replace("jetproxy://", "")
            jet_link.jetproxy = True
            jet_link.direct = True
        
        # Find extractor for link
        e = jet_extractor.find_extractor(jet_link)

        # If the extractor is a shortener, resolve the shortened link and get find a new extractor to use
        if e is not None and e.shortener:
            jet_link = e.get_link(jet_link.address)
            e = jet_extractor.find_extractor(jet_link.address)
        
        if e is None:
            if jet_link.resolveurl:
                resolved_url = resolveurl.HostedMediaFile(jet_link.address).resolve()
                if resolved_url:
                    jet_link.address = resolved_url
            elif ".m3u8" not in jet_link.address and not jet_link.direct:
                use_iframe = xbmcgui.Dialog().notification("No extractor", f"Thank you for using [COLORyellow][B]THE TEAM's[/B][/COLOR] JetExtractor.\n The Extractor does not have a scraper for this site.\n The extractor will try to resolve the link. ")
                if use_iframe:
                    return True
                iframes = jet_extractor.iframe_extractor(jet_link.address)
                if len(iframes) > 0:
                    link_idx = link_dialog([l.address + (f"({l.name})" if l.name is not None else "") for l in iframes], return_idx=True)
                    if link_idx is None:
                        return True
                    jet_link = iframes[link_idx]
                    ext = jet_extractor.find_extractor(jet_link)
                    if ext is not None:
                        jet_link = ext.get_link(jet_link)
                else:
                    xbmcgui.Dialog().ok("Error", "Jetextractors could not find a playable link for this URL.")
                    return True
        elif not jet_link.direct:
            jet_link = e.get_link(jet_link)

        if urllib.parse.urlparse(jet_link.address).netloc in jet_config.get_config().get("hls_domains", []):
            jet_link.inputstream = JetInputstreamFFmpegDirect.default()
        elif e is not None and e.domains[0] in jet_config.get_config().get("hls_domains", []):
            jet_link.inputstream = JetInputstreamFFmpegDirect.default()
        

        try:
            addon_id = xbmcaddon.Addon().getAddonInfo("id")
            jet_config.log_addon_usage(addon_id, jet_link.address)
        except:
            pass
        jet_addr: str = jet_link.xbmc_format()

        # Set ListItem properties
        liz = xbmcgui.ListItem(item.get("title", jet_link.name or jet_link.address), path=jet_addr)
        liz.setInfo("video", {
            "title": title
        })
        liz.setArt({
            "thumb": thumbnail,
            "icon": thumbnail
        })

        if jet_link.jetproxy:
            xbmc.executebuiltin(f"RunPlugin(plugin://plugin.video.jetproxy/play/{jet_addr})")
            return True
        
        if jet_link.inputstream is not None:
            jet_link.inputstream.set_properties(liz)
            if isinstance(jet_link.inputstream, JetInputstreamAdaptive) and jet_link.inputstream.manifest_type == "mpd" and jet_link.inputstream.license_key is not None:
                is_helper = inputstreamhelper.Helper("mpd", drm="widevine")
                if not is_helper.check_inputstream():
                    sys.exit()
            xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, liz)
        
        jet_addr = jet_addr.strip()
        xbmc.Player().play(jet_addr, listitem=liz)
        return True
    
    def routes(self, plugin):
        @plugin.route(f"/{self.name}/sites")
        def sites():
            jen_list = []

            extractors = sorted(jet_extractor.get_extractors(), key=lambda x: type(x).__name__)
            for e in extractors:
                if e.name == None or e.resolve_only:
                    continue
                jen_data = {
                    "title": e.name,
                    self.name: e.name,
                    "type": "item"
                }
                jen_list.append(jen_data)
            jen_list = [run_hook("process_item", item) for item in jen_list]
            jen_list = [run_hook("get_metadata", item, return_item_on_failure=True) for item in jen_list]
            run_hook("display_list", jen_list)


        @plugin.route(f"/{self.name}/games/<path:site>")
        def get_items(site):
            if len(plugin.args) == 0:
                params = None
            else:
                params = {}
                for key, value in plugin.args.items():
                    params[key] = value[0]
            
            for e in jet_extractor.get_extractors():
                if site == e.name:
                    progress_dialog = xbmcgui.DialogProgress()
                    event = threading.Event()
                    statuses: list[str] = []
                    def callback(progress: JetExtractorProgress):
                        count = len(progress.items) if progress.items is not None else 0
                        if progress.status is not None:
                            statuses.append(progress.status)
                        message = f"Fetched {count} items" if not event.is_set() else f"Canceling... (Fetched {count} items)"
                        if len(statuses) > 0:
                            message += "\n"
                            message += "\n".join(statuses[::-1])
                        progress_dialog.update(count, message)
                    progress_dialog.create(f"JetExtractor: {e.name}", f"Fetched 0 items")
                    extractor_progress = JetExtractorProgress(event=event, callback=callback)

                    with ThreadPoolExecutor() as executor:
                        thread = executor.submit(e.get_items, params=params, progress=extractor_progress)
                        while thread.running():
                            if progress_dialog.iscanceled():
                                event.set()
                                progress_dialog.update(0, f"Canceling...")
                            xbmc.sleep(100)
                        items = thread.result()
                    progress_dialog.close()

                    if event.is_set() and len(items) == 0:
                        return
                    
                    jen_list = []
                    for item in items:
                        if item.params is not None and len(item.links) == 0:
                            jen_data = {
                                "title": item.title,
                                "thumbnail": item.icon,
                                "fanart": item.icon,
                                "summary": item.title,
                                self.name: f"{site}?{urllib.parse.urlencode(item.params)}",
                                "type": "dir"
                            }
                        else:
                            jen_data = {
                                "title": "[COLORdodgerblue]%s[COLORwhite] |[B][I] %s[/B][/I]\n  [COLORred]%s[/COLOR]" % (item.league.replace("'", "") if item.league is not None else "", item.title, format_time(item.starttime)),
                                "thumbnail": item.icon,
                                "fanart": item.icon,
                                "summary": item.title,
                                self.name: [link.to_dict() for link in item.links],
                                "type": "item"
                            }
                        jen_list.append(jen_data)
                    jen_list = [run_hook("process_item", item) for item in jen_list]
                    jen_list = [run_hook("get_metadata", item, return_item_on_failure=True) for item in jen_list]
                    run_hook("display_list", jen_list)
                    break
        

        @plugin.route(f"/{self.name}/search/<path:query>")
        def search_games(query):
            if query == "*":
                query = xbmcgui.Dialog().input("Search game")
                if query == "": return
            addon = xbmcaddon.Addon()
            USER_DATA_DIR = translatePath(addon.getAddonInfo("profile"))
            if not os.path.exists(os.path.join(USER_DATA_DIR, f"{self.name}_disabled.json")):
                disabled = DEFAULT_DISABLED
            else:
                f = open(os.path.join(USER_DATA_DIR, f"{self.name}_disabled.json"), "r")
                disabled = json.load(f)
                f.close()
            items = jet_extractor.search_extractors(query, disabled)
            empty_date = datetime(year=2030, month=12, day=31)
            jen_list = []
            
            for item in items:
                
                jen_data = {
                    "title": "[COLORdodgerblue]%s[COLORwhite] |[B][I] %s[/B][/I]\n  [COLORred]%s | %s[/COLOR]" % (item.league.replace("'", "") if item.league is not None else "", item.title, item.extractor, format_time(item.starttime)),
                    "thumbnail": item.icon,
                    "fanart": item.icon,
                    "summary": item.title,
                    self.name: [link.to_dict() for link in item.links],
                    "time": item.starttime.timestamp() if item.starttime != None else empty_date.timestamp(),
                    "type": "item"
                }
                jen_list.append(jen_data)
            
            jen_list = sorted(jen_list, key=lambda x: x["time"])
            jen_list = [run_hook("process_item", item) for item in jen_list]
            jen_list = [run_hook("get_metadata", item, return_item_on_failure=True) for item in jen_list]
            run_hook("display_list", jen_list)


        @plugin.route(f"/{self.name}/search_dialog/<path:query>")
        def search_dialog(query):
            query = urllib.parse.unquote_plus(query)
            if query == "*":
                query = xbmcgui.Dialog().input("Search game")
                if query == "": return
            addon = xbmcaddon.Addon()
            USER_DATA_DIR = translatePath(addon.getAddonInfo("profile"))
            if not os.path.exists(os.path.join(USER_DATA_DIR, f"{self.name}_disabled.json")):
                disabled = DEFAULT_DISABLED
            else:
                f = open(os.path.join(USER_DATA_DIR, f"{self.name}_disabled.json"), "r")
                disabled = json.load(f)
                f.close()
            games = jet_extractor.search_extractors(query, disabled)
            empty_date = datetime(year=2030, month=12, day=31)
            jen_list = []
            
            for game in games:
                jen_data = {
                    "title": "[COLORdodgerblue]%s[COLORwhite] |[B][I] %s[/B][/I]\n  [COLORred]%s | %s[/COLOR]" % (game.league.replace("'", "") if game.league is not None else "", game.title, game.extractor, format_time(game.starttime)),
                    "thumbnail": game.icon,
                    "fanart": game.icon,
                    "summary": game.title,
                    self.name: [link.to_dict() for link in game.links],
                    "time": game.starttime.timestamp() if game.starttime != None else empty_date.timestamp(),
                    "type": "item"
                }
                jen_list.append(jen_data)
            
            idx = link_dialog([game["title"] for game in jen_list], return_idx=True, hide_links=False)
            if idx == None:
                return True
            self.play_video(json.dumps(jen_list[idx]))
        

        @plugin.route(f"/{self.name}/play")
        def play():
            urls = [ JetLink(url) for url in plugin.args["urls"][0].split("***") ]
            if len(plugin.args) > 1:
                for link in urls:
                    link.params = {}
                    for key, value in plugin.args.items():
                        if key == "urls":
                            continue
                        link.params[key] = value[0]

            xbmc.log(json.dumps({ self.name: [ link.to_dict() for link in urls ]}), xbmc.LOGINFO)
            return self.play_video(json.dumps({ self.name: [ link.to_dict() for link in urls ]}))


        @plugin.route(f"/{self.name}/dialog")
        def dialog():
            query = xbmcgui.Dialog().input("Enter link")
            if not query: return
            self.play_video(json.dumps({self.name: [query]}))
        

        @plugin.route(f"/{self.name}/clear_config")
        def clear_config():
            jet_config.delete_config()
            xbmcgui.Dialog().notification("Success", "Jetextractors config cleared.")

        @plugin.route(f"/{self.name}/set_uuid")
        def set_uuid():
            uuid = jet_config.get_user_uuid()
            new_uuid = xbmcgui.Dialog().input("Set UUID", uuid)
            if new_uuid:
                jet_config.set_user_uuid(new_uuid)
                xbmcgui.Dialog().notification("Success", "Set UUID to " + new_uuid)
            
    

        @plugin.route(f"/{self.name}/extractor_settings")
        def extractor_settings():
            addon = xbmcaddon.Addon()
            USER_DATA_DIR = translatePath(addon.getAddonInfo("profile"))
            if not os.path.exists(USER_DATA_DIR):
                os.makedirs(USER_DATA_DIR)
            if not os.path.exists(os.path.join(USER_DATA_DIR, f"{self.name}_disabled.json")):
                f = open(os.path.join(USER_DATA_DIR, f"{self.name}_disabled.json"), "w")
                f.write(json.dumps(DEFAULT_DISABLED))
                f.close()
            
            options = filter(lambda x: x.name != None, jet_extractor.get_extractors())
            option_names = [module.name for module in options]
            enabled = []
            f = open(os.path.join(USER_DATA_DIR, f"{self.name}_disabled.json"), "r+")
            disabled_extractors = json.load(f)
            for i, option in enumerate(option_names):
                if option not in disabled_extractors:
                    enabled.append(i)
            
            dialog = xbmcgui.Dialog().multiselect("Extractors", options=option_names, preselect=enabled)
            if dialog == None: return
            disabled = []
            for i in range(len(option_names)):
                if i not in dialog:
                    disabled.append(option_names[i])
            
            f.seek(0)
            f.write(json.dumps(disabled))
            f.truncate()
            f.close()
            xbmcgui.Dialog().ok("Success!", "Settings saved.")
        
        # @plugin.route(f"/{self.name}/iptv_setup")
        # def iptv_setup():
        #     if not xbmcgui.Dialog().yesno("IPTV Simple Client Setup", "Update IPTV Simple Client settings to use JET TV M3U8 and EPG?"):
        #         return
        #     try:
        #         addon = xbmcaddon.Addon('pvr.iptvsimple')
        #         addon.setSetting(id="m3uUrl", value=base64.b64decode("aHR0cHM6Ly9tYWduZXRpYzEucmF0cGFjay5hcHBib3hlcy5jby9qZXQvcGxheWxpc3QxLm0zdTg=").decode("utf-8"))
        #         addon.setSetting(id="epgUrl", value=base64.b64decode("aHR0cHM6Ly9tYWduZXRpYzEucmF0cGFjay5hcHBib3hlcy5jby9qZXQvZXBnLnhtbA==").decode("utf-8"))
        #         addon.setSetting(id="m3uPathType", value="1")
        #         addon.setSetting(id="epgPathType", value="1")
        #         xbmc.executeJSONRPC('{"jsonrpc":"2.0","method":"Addons.SetAddonEnabled","params":{"addonid":"pvr.iptvsimple","enabled":true},"id":1}')
        #         xbmcgui.Dialog().ok("Success", "IPTV Simple Client settings updated.")
        #     except:
        #         xbmcgui.Dialog().ok("Error", "IPTV Simple Client is not installed.")
            



def format_time(date):
    return utc_to_local(date).strftime("%m/%d %I:%M %p") if date != None else ""

# https://stackoverflow.com/questions/4563272/convert-a-python-utc-datetime-to-a-local-datetime-using-only-python-standard-lib
def utc_to_local(utc_dt):
    timestamp = calendar.timegm(utc_dt.timetuple())
    local_dt = datetime.fromtimestamp(timestamp)
    assert utc_dt.resolution >= timedelta(microseconds=1)
    return local_dt.replace(microsecond=utc_dt.microsecond)


