import json
import sys
import xbmc
import xbmcgui
import xbmcaddon
import resolveurl
from ..plugin import Plugin

addon_id = xbmcaddon.Addon().getAddonInfo('id')
default_icon = xbmcaddon.Addon(addon_id).getAddonInfo('icon')


class default_play_video(Plugin):
    name = "default video playback"
    priority = 0
    
    def play_video(self, item):
        item = json.loads(item)
        link = item.get("link", "")
        if not link:
            return False
        title = item["title"]
        thumbnail = item.get("thumbnail", default_icon)
        summary = item.get("summary", "")
        liz = xbmcgui.ListItem(title)
        if item.get("infolabels"):
            liz.setInfo("video", item["infolabels"])
        else:
            liz.setInfo("video", {"title": title, "plot": summary})
        liz.setArt({"thumb": thumbnail, "icon": thumbnail, "poster": thumbnail})
        
        if item.get('pack') is not None:
            hmf = resolveurl.HostedMediaFile(link, return_all=True)
            if hmf:
                allfiles = hmf.resolve()
                if isinstance(allfiles, str):
                    link = allfiles
                elif isinstance(allfiles, list):
                    labels = [file.get('name') for file in allfiles]
                    ret = xbmcgui.Dialog().select('Choose a link', labels)
                    if ret == -1:
                        sys.exit()
                    stream_url = allfiles[ret].get('link')
                
                    hmf2 = resolveurl.HostedMediaFile(stream_url)
                    if hmf2.valid_url():
                        link = resolveurl.resolve(stream_url)
        else:
            hmf = resolveurl.HostedMediaFile(link)
            if hmf.valid_url():
                link = hmf.resolve()
                
        liz.setPath(link)
        xbmc.Player().play(link, liz)
        return True
