# -*- coding: utf-8 -*-3
"""
 __
|  \   _  _  _|_
|__/\/| )(_|_)|_\/
    /           /
"""

from resources.lib.modules.control import  joinPath, artPath, dialog, setting as getSetting
from resources.lib.modules.library import lib_tools
from resources.lib.windows.base import BaseDialog
from resources.lib.modules import control


class TraktImportListManagerXML(BaseDialog):
	def __init__(self, *args, **kwargs):
		BaseDialog.__init__(self, args)
		self.window_id = 2050
		self.results = kwargs.get('results')
		self.total_results = str(len(self.results))
		self.highlight_color = getSetting('highlight.color')
		self.selected_items = []
		self.make_items()
		self.set_properties()

	def onInit(self):
		win = self.getControl(self.window_id)
		win.addItems(self.item_list)
		self.setFocusId(self.window_id)

	def run(self):
		self.doModal()
		self.clearProperties()
		return self.selected_items

	# def onClick(self, controlID):
		# from resources.lib.modules import log_utils
		# log_utils.log('controlID=%s' % controlID)

	def onAction(self, action):
		try:
			if action in self.selection_actions:
				focus_id = self.getFocusId()
				if focus_id == 2050: # listItems
					position = self.get_position(self.window_id)
					chosen_listitem = self.item_list[position]
					trakt_id = chosen_listitem.getProperty('dynasty.trakt_id')
					if chosen_listitem.getProperty('dynasty.isSelected') == 'true':
						chosen_listitem.setProperty('dynasty.isSelected', '')
						if trakt_id in str(self.selected_items):
							pos = next((index for (index, d) in enumerate(self.selected_items) if d["trakt_id"] == trakt_id), None)
							self.selected_items.pop(pos)
					else:
						chosen_listitem.setProperty('dynasty.isSelected', 'true')
				elif focus_id == 2051: # OK Button
					self.selected_items = []
					for item in self.item_list:
						if item.getProperty('dynasty.isSelected') == 'true':
							self.selected_items.append({'type': item.getProperty('dynasty.action'), 'list_name': item.getProperty('dynasty.list_name'), 'url': item.getProperty('dynasty.url')})
					self.close()
				elif focus_id == 2052: # Cancel Button
					self.selected_items = None
					self.close()
				# elif focus_id == 2053: # Import Now Button
				# 	self.selected_items = []
				# 	for item in self.item_list:
				# 		if item.getProperty('dynasty.isSelected') == 'true':
				# 			self.selected_items.append({'type': item.getProperty('dynasty.action'), 'list_name': item.getProperty('dynasty.list_name'), 'url': item.getProperty('dynasty.url')})
				# 	itemtopass = self.selected_items
				# 	self.close()
				# 	lib_tools().importNow(itemtopass)
			elif action in self.context_actions:
				cm = []
				chosen_listitem = self.item_list[self.get_position(self.window_id)]
				source_id = chosen_listitem.getProperty('dynasty.trakt_id')
				if source_id: cm += [('[B]Clear List Database[/B]', 'clearDB')]
				chosen_cm_item = dialog.contextmenu([i[0] for i in cm])
				if chosen_cm_item == -1: return
				cm_action = cm[chosen_cm_item][1]
				if cm_action == 'clearDB':
					lib_tools().clearListfromDB(source_id)
			elif action in self.closing_actions:
				self.selected_items = None
				self.close()
		except:
			from resources.lib.modules import log_utils
			log_utils.error()
			self.close()

	def make_items(self):
		def builder():
			for count, item in enumerate(self.results, 1):
				try:
					isMovie = ''
					isTVShow = ''
					isMixed = ''
					if item.get('action').split("&")[0] == 'movies':
						isMovie = 'true'
					if item.get('action').split("&")[0] == 'tvshows':
						isTVShow = 'true'
					if item.get('action').split("&")[0] == 'mixed':
						isMixed = 'true'
					listitem = self.make_listitem()
					listitem.setProperty('dynasty.list_owner', item.get('list_owner'))
					listitem.setProperty('dynasty.list_name', str(item.get('list_name')))
					listitem.setProperty('dynasty.list_owner_slug', str(item.get('list_owner_slug')))
					listitem.setProperty('dynasty.trakt_id', str(item.get('list_id')))
					listitem.setProperty('dynasty.item_count', str(item.get('list_count')))
					listitem.setProperty('dynasty.likes', str(item.get('likes')))
					listitem.setProperty('dynasty.action', str(item.get('action')))
					listitem.setProperty('dynasty.isMovie', isMovie)
					listitem.setProperty('dynasty.isTVShow', isTVShow)
					listitem.setProperty('dynasty.isMixed', isMixed)
					listitem.setProperty('dynasty.isSelected', item.get('selected'))
					listitem.setProperty('dynasty.url', item.get('url'))
					listitem.setProperty('dynasty.count', '%02d.)' % count)
					yield listitem
				except:
					from resources.lib.modules import log_utils
					log_utils.error()
		try:
			self.item_list = list(builder())
			self.total_results = str(len(self.item_list))
		except:
			from resources.lib.modules import log_utils
			log_utils.error()

	def set_properties(self):
		try:
			self.setProperty('dynasty.total_results', self.total_results)
			self.setProperty('dynasty.highlight.color', self.highlight_color)
			self.setProperty('dynasty.trakt_icon', joinPath(artPath(), 'trakt.png'))
		except:
			from resources.lib.modules import log_utils
			log_utils.error()