# -*- coding: utf-8 -*-
"""
 __                
|  \   _  _  _|_   
|__/\/| )(_|_)|_\/ 
    /           /  
 
"""

from resources.lib.modules.control import directory as endOfDirectory
from resources.lib.modules import youtube_menu


class yt_index:  # initializes as musicvids, functions can override based on action and subid.
    def __init__(self):
        self.action = 'musicvids'
        self.base_url = 'https://www.midian.appboxes.co/wolfyB/Th3L48/text/extra/'
        self.mainmenu = self.base_url + 'musicvids.txt'
        self.submenu = '%s/%s.txt'
        self.default_icon = '%s/icons/music_video_folder_icon.png'
        self.default_fanart = '%s/icons/music_video_folder_fanart.jpg'

    def init_vars(self, action):
        try:
            if action == 'youtube':
                self.action = 'youtube'
                self.base_url = 'https://www.midian.appboxes.co/wolfyB/Th3L48/text/extra/'
                self.mainmenu = '%sytmain.txt' % (self.base_url)

            elif action == 'tvReviews':
                self.action   = 'tvReviews'
                self.base_url = 'https://www.midian.appboxes.co/wolfyB/Th3L48/text/extra/'
                self.mainmenu = '%stvtrailer.txt' % (self.base_url)

            elif action == 'movieReviews':
                self.action   = 'movieReviews'
                self.base_url = 'https://www.midian.appboxes.co/wolfyB/Th3L48/text/extra/'
                self.mainmenu = '%smovietrailer.txt' % (self.base_url)
                
            elif action == 'oldies':
                self.action   = 'oldies'
                self.base_url = 'https://www.midian.appboxes.co/wolfyB/Th3L48/text/extra/'
                self.mainmenu = '%soldies.txt' % (self.base_url)

            elif action == 'oldmovies':
                self.action   = 'oldmovies'
                self.base_url = 'https://www.midian.appboxes.co/wolfyB/Th3L48/text/extra/'
                self.mainmenu = '%soldmovies.txt' % (self.base_url)

            elif action == 'oldtvshows':
                self.action   = 'oldtvshows'
                self.base_url = 'https://www.midian.appboxes.co/wolfyB/Th3L48/text/extra/'
                self.mainmenu = '%soldtvshows.txt' % (self.base_url)

            elif action == 'oldtcartoons':
                self.action   = 'oldtcartoons'
                self.base_url = 'https://www.midian.appboxes.co/wolfyB/Th3L48/text/extra/'
                self.mainmenu = '%soldtcartoons.txt' % (self.base_url)

            elif action == 'kids':
                self.action   = 'kids'
                self.base_url = 'https://www.midian.appboxes.co/wolfyB/Th3L48/text/extra/'
                self.mainmenu = '%skidsyt.txt' % (self.base_url)

            self.submenu = self.submenu % (self.base_url, '%s')
            self.default_icon = self.default_icon % (self.base_url)
            self.default_fanart = self.default_fanart % (self.base_url)
        except:
            from resources.lib.modules import log_utils
            log_utils.error()

    def root(self, action):
        try:
            self.init_vars(action)
            menuItems = youtube_menu.youtube_menu().processMenuFile(self.mainmenu)
            for name, section, searchid, subid, playlistid, channelid, videoid, iconimage, fanart, description in menuItems:
                if subid != 'false': # Means this item points to a submenu
                    youtube_menu.youtube_menu().addMenuItem(name, self.action, subid, iconimage, fanart, description, True)
                elif searchid != 'false': # Means this is a search term
                    youtube_menu.youtube_menu().addSearchItem(name, searchid, iconimage, fanart)
                elif videoid != 'false': # Means this is a video id entry
                    youtube_menu.youtube_menu().addVideoItem(name, videoid, iconimage, fanart)
                elif channelid != 'false': # Means this is a channel id entry
                    if channelid.startswith('UC'):
                        youtube_menu.youtube_menu().addChannelItem(name, channelid, iconimage, fanart)
                    else:
                        youtube_menu.youtube_menu().addUserItem(name, channelid, iconimage, fanart) # This really needs it's own userid created in the .txt files
                elif playlistid != 'false': # Means this is a playlist id entry
                    youtube_menu.youtube_menu().addPlaylistItem(name, playlistid, iconimage, fanart)
                elif section != 'false': # Means this is a section placeholder/info line
                    youtube_menu.youtube_menu().addSectionItem(name, self.default_icon, self.default_fanart)
            self.endDirectory()
        except:
            from resources.lib.modules import log_utils
            log_utils.error()

    def get(self, action, subid):
        try:
            self.init_vars(action)
            thisMenuFile = self.submenu % (subid)
            menuItems = youtube_menu.youtube_menu().processMenuFile(thisMenuFile)
            for name, section, searchid, subid, playlistid, channelid, videoid, iconimage, fanart, description in menuItems:
                if subid != 'false': # Means this item points to a submenu
                    youtube_menu.youtube_menu().addMenuItem(name, self.action, subid, iconimage, fanart, description, True)
                elif searchid != 'false': # Means this is a search term
                    youtube_menu.youtube_menu().addSearchItem(name, searchid, iconimage, fanart)
                elif videoid != 'false': # Means this is a video id entry
                    youtube_menu.youtube_menu().addVideoItem(name, videoid, iconimage, fanart)
                elif channelid != 'false': # Means this is a channel id entry
                    if channelid.startswith('UC'):
                        youtube_menu.youtube_menu().addChannelItem(name, channelid, iconimage, fanart)
                    else:
                        youtube_menu.youtube_menu().addUserItem(name, channelid, iconimage, fanart) # This really needs it's own userid created in the .txt files
                elif playlistid != 'false': # Means this is a playlist id entry
                    youtube_menu.youtube_menu().addPlaylistItem(name, playlistid, iconimage, fanart)
                elif section != 'false': # Means this is a section placeholder/info line
                    youtube_menu.youtube_menu().addSectionItem(name, self.default_icon, self.default_fanart)
            self.endDirectory()
        except:
            from resources.lib.modules import log_utils
            log_utils.error()

    def endDirectory(self):
        from sys import argv # some functions throw invalid handle -1 unless this is imported here.
        endOfDirectory(int(argv[1]), cacheToDisc=True)