# -*- coding: utf-8 -*-
"""
 __
|  \   _  _  _|_
|__/\/| )(_|_)|_\/
    /           /
"""

from resources.lib.modules.control import addonPath, addonId, getDynastyVersion, joinPath
from resources.lib.windows.textviewer import TextViewerXML


def get(file):
	dynasty_path = addonPath(addonId())
	dynasty_version = getDynastyVersion()
	helpFile = joinPath(dynasty_path, 'resources', 'help', file + '.txt')
	f = open(helpFile, 'r', encoding='utf-8', errors='ignore')
	text = f.read()
	f.close()
	heading = '[B]Dynasty -  v%s - %s[/B]' % (dynasty_version, file)
	windows = TextViewerXML('textviewer.xml', dynasty_path, heading=heading, text=text)
	windows.run()
	del windows