# -*- coding: utf-8 -*-

# Author/Copyright: fr33p0rt <fr33p0rt@protonmail.com>
# License: Freeware (licensed to use and redistribute)

import os
import re
import random

try:
    import xbmc, xbmcaddon, xbmcplugin, xbmcgui, xbmcvfs
except:
    from unittest.mock import Mock
    from unittest.mock import MagicMock
    xbmc = Mock()
    xbmcaddon = Mock()
    xbmcaddon.Addon().getAddonInfo = MagicMock(side_effect=['plugin.video.co.bellesa', '.', 'bellesa.co (tmpl)', '0.0.1'])
    xbmcplugin = Mock()
    xbmcplugin.getSetting = MagicMock(side_effect=['a,b,c,d', '0', '1'] + 2 * ['true'] + ['false'])
    xbmcgui = Mock()
    xbmcvfs = Mock()


from urllib.parse import urlencode, parse_qs
import sys

from resources.lib.bellesa import Bellesa
from resources.lib.anal import Anal

addon_url = sys.argv[0]
addon_handle = int(sys.argv[1])
addon_args = parse_qs(sys.argv[2][1:])

def get_addon_url(params, **kwargs):
    params.update(kwargs)
    return "%s?&%s" % (addon_url, urlencode(params))

def get_addon_parameter(name):
    return (lambda _: None if _ is None else _[0])(addon_args.get(name, None))

def list_videos(url):

    xbmcplugin.setContent(addon_handle, 'videos')

    videos, next_page = bellesa.get_video_pages(url)
    for i in videos:
        if addon_cfg['shuffle_title']:
            item_video = xbmcgui.ListItem(label=''.join(random.sample(i['nam'], len(i['nam']))).strip(), label2=str(i['tgs']))
        else:
            item_video = xbmcgui.ListItem(label=i['nam'], label2=str(i['tgs']))
        item_video.setArt({'icon': i['img'] if addon_cfg['show_video_image'] else None,
                           'thumb': i['img'] if addon_cfg['show_video_image'] else None,
                           'fanart': i['img'] if addon_cfg['show_video_background'] else None})

        item_video.setProperty('IsPlayable', 'true')
        item_video.setInfo('video', {'mediatype': 'video', 'title': i['nam'], 'duration': i['dur'],
                                     'genre': 'Porn' if addon_cfg['show_genre'] else None,
                                     'cast': i['cst'], 'artist': i['cst'], 'studio': i['std'],
                                     'plot': ' | '.join(i['tgs']) if addon_cfg['show_tags'] else None})

        if i['res']:
            height = max(map(lambda _: int(_), i['res'].split(',')))
            item_video.addStreamInfo('video', {'duration': i['dur'], 'width': 16 * height // 9, 'height': height})
        else:
            item_video.addStreamInfo('video', {'duration': i['dur'], 'width': 1280, 'height': 720})
        xbmcplugin.addDirectoryItem(addon_handle, get_addon_url({'u': i['url']}), item_video, False)


    if next_page:
        item_page = xbmcgui.ListItem(label='Page (%s)' % next_page['nam'])
        item_page.setProperty('IsPlayable', 'false')
        xbmcplugin.addDirectoryItem(addon_handle, get_addon_url({'u': next_page['url']}), item_page, True)
    else:
        item_page = xbmcgui.ListItem(label='Page (2)')
        item_page.setProperty('IsPlayable', 'false')
        xbmcplugin.addDirectoryItem(addon_handle, get_addon_url({'u': 'buy'}), item_page, True)


addon = xbmcaddon.Addon()

resolutions = 3 * [720] + [480, 360, 0]
addon_details = {'id': addon.getAddonInfo('id'), 'path': addon.getAddonInfo('path'),
                 'name': addon.getAddonInfo('name'), 'version': addon.getAddonInfo('version')}
addon_cfg = {'search_presets': xbmcplugin.getSetting(addon_handle, 'search_presets').split(','),
             'resolution': resolutions[int(xbmcplugin.getSetting(addon_handle, 'resolution'))],
             'show_video_image': xbmcplugin.getSetting(addon_handle, 'show_video_image') == 'true',
             'show_video_background': xbmcplugin.getSetting(addon_handle, 'show_video_background') == 'true',
             'show_genre': xbmcplugin.getSetting(addon_handle, 'show_genre') == 'true',
             'show_tags': xbmcplugin.getSetting(addon_handle, 'show_tags') == 'true',
             'shuffle_title': xbmcplugin.getSetting(addon_handle, 'shuffle_title') == 'true',
             'show_remote_path': xbmcplugin.getSetting(addon_handle, 'show_remote_path') == 'true'}

bellesa = Bellesa()
url = get_addon_parameter('u')

if url is not None and url == 'search_form':

    play_item = xbmcgui.ListItem(path=os.path.join(addon_details['path'], 'resources', 'empty.mp4'))
    xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)
    keyboard = xbmc.Keyboard('', xbmcaddon.Addon().getLocalizedString(31003))
    keyboard.doModal()
    if (keyboard.isConfirmed()):
        search_string = keyboard.getText()
        if len(search_string) >= 3:
            xbmc.executebuiltin('Container.Update(%s/?u=%s)' % (addon_url, bellesa.make_search_url(search_string)))

else:
    if url is None or re.match(r'https://www.bellesa.co/videos\?page=\d+', url) or re.match(r'https://www.bellesa.co/search\?', url):

        if addon_cfg['show_remote_path']:
            xbmcplugin.setPluginCategory(addon_handle, url.replace('https://www.bellesa.co', '') if url else '/videos')

        if url is None:
            Anal().report('main', '-', addon_details)

            search_item = xbmcgui.ListItem(xbmcaddon.Addon().getLocalizedString(31001))
            search_item.setArt({'icon': 'DefaultAddonsSearch.png', 'thumb': 'DefaultAddonsSearch.png'})
            search_item.setProperty('IsPlayable', 'false')
            xbmcplugin.addDirectoryItem(addon_handle, get_addon_url({'u': 'search_menu'}), search_item, True)

            filter_item = xbmcgui.ListItem('Filter ...')
            filter_item.setArt({'icon': 'DefaultAddonContextItem.png', 'thumb': 'DefaultAddonContextItem.png'})
            filter_item.setProperty('IsPlayable', 'false')
            xbmcplugin.addDirectoryItem(addon_handle, get_addon_url({'u': 'filter_menu'}), filter_item, True)

        list_videos(url)

    elif re.match(r'https://www.bellesa.co/videos/\d+', url):
        Anal().report('play', url, addon_details)
        video_stream = bellesa.get_video_stream(url, addon_cfg)
        play_item = xbmcgui.ListItem(path=video_stream)
        xbmcplugin.setResolvedUrl(addon_handle, True, listitem=play_item)

    elif url == 'search_menu':
        search_item = xbmcgui.ListItem(xbmcaddon.Addon().getLocalizedString(31002))
        search_url = get_addon_url({'u': 'buy'})
        xbmcplugin.setContent(addon_handle, 'video')
        search_item.setArt({'icon': 'DefaultAddonsSearch.png', 'thumb': 'DefaultAddonsSearch.png'})
        search_item.setInfo('video', {'mediatype': 'video'})
        search_item.setProperty('IsPlayable', 'true')
        xbmcplugin.addDirectoryItem(addon_handle, search_url, search_item, False)

        for i in filter(lambda _: len(_) >= 3, addon_cfg['search_presets']):
            if addon_cfg['shuffle_title']:
                search_item = xbmcgui.ListItem(label=''.join(random.sample(i, len(i))).strip())
            else:
                search_item = xbmcgui.ListItem(label=i)
            search_item.setArt({'icon': 'DefaultAddonsSearch.png', 'thumb': 'DefaultAddonsSearch.png'})
            search_item.setProperty('IsPlayable', 'false')
            xbmcplugin.addDirectoryItem(addon_handle, get_addon_url({'u': bellesa.make_search_url(i)}), search_item, True)
            break

    elif url == 'buy':
        Anal().report('buy', '-', addon_details)
        xbmc.executebuiltin("ShowPicture(%s)" % os.path.join(addon_details['path'], 'resources', 'buy', 'buy-feature.png'))
        exit(0)

    elif url == 'filter_menu':
        filters = bellesa.get_filters(None)

        for filter_category in filters:
            for filter in filters[filter_category]:
                if addon_cfg['shuffle_title']:
                    filter_item = xbmcgui.ListItem(label='%s (%s)' % (''.join(random.sample(filter['name'], len(filter['name']))).strip(), filter['count']))
                else:
                    filter_item = xbmcgui.ListItem(label='%s (%s)' % (filter['name'], filter['count']))
                filter_item.setArt({'icon': 'DefaultAddonContextItem.png', 'thumb': 'DefaultAddonContextItem.png'})
                filter_item.setProperty('IsPlayable', 'false')
                xbmcplugin.addDirectoryItem(addon_handle, get_addon_url({'u': bellesa.make_filter_url(filter_category, filter['handle'])}), filter_item, True)

    xbmcplugin.endOfDirectory(addon_handle)
