# -*- coding: utf-8 -*-
# _____ _          _           _       _    _ _                  _ 
#|_   _| |        | |         | |     | |  | (_)                | |
#  | | | |__   ___| |     __ _| |__   | |  | |_ ______ _ _ __ __| |
#  | | | '_ \ / _ \ |    / _` | '_ \  | |/\| | |_  / _` | '__/ _` |
#  | | | | | |  __/ |___| (_| | |_) | \  /\  / |/ / (_| | | | (_| |
#  \_/ |_| |_|\___\_____/\__,_|_.__/   \/  \/|_/___\__,_|_|  \__,_|
#

import os, uservar,re
import six
from kodi_six import xbmc, xbmcaddon, xbmcgui, xbmcplugin, xbmcvfs

try:
    import wizard as wiz
    import thread as _thread
except ImportError:
    from resources.libs import wizard as wiz
    import _thread
try:
    import json as simplejson
except:
    import simplejson

KODIV  = float(xbmc.getInfoLabel("System.BuildVersion")[:4])
COLOR1 = uservar.COLOR1
COLOR2 = uservar.COLOR2
transPath  = xbmc.translatePath if KODIV < 19 else xbmcvfs.translatePath



def getOld(old):
    try:
        old = '"%s"' % old 
        query = '{"jsonrpc":"2.0", "method":"Settings.GetSettingValue","params":{"setting":%s}, "id":1}' % (old)
        response = xbmc.executeJSONRPC(query)
        response = simplejson.loads(response)
        if 'result' in response:
            if 'value' in response['result']:
                return response ['result']['value'] 
    except:
        pass
    return None

def setNew(new, value):
    try:
        new = '"%s"' % new
        value = '"%s"' % value
        query = '{"jsonrpc":"2.0", "method":"Settings.SetSettingValue","params":{"setting":%s,"value":%s}, "id":1}' % (new, value)
        response = xbmc.executeJSONRPC(query)
    except:
        pass
    return None

def swapSkins(skin):
    if skin == 'skin.confluence':
        HOME     = transPath('special://home/')
        skinfold = os.path.join(HOME, 'userdata', 'addon_data', 'skin.confluence')
        settings = os.path.join(skinfold, 'settings.xml')
        if not os.path.exists(settings):
            string = '<settings>\n    <setting id="FirstTimeRun" type="bool">true</setting>\n</settings>'
            os.makedirs(skinfold)
            f = xbmcvfs.File(settings, 'w'); f.write(string); f.close()
        else: xbmcaddon.Addon(id='skin.confluence').setSetting('FirstTimeRun', 'true')
    old = 'lookandfeel.skin'
    value = skin
    current = getOld(old)
    new = old
    setNew(new, value)
    #   if not xbmc.getCondVisibility(Skin.HasSetting(FirstTimeRun)):
    #       while xbmc.getCondVisibility('Window.IsVisible(1112)'):
    #           xbmc.executebuiltin('SendClick(100)')

def swapUS():
    new = '"addons.unknownsources"'
    value = 'true'
    query = '{"jsonrpc":"2.0", "method":"Settings.GetSettingValue","params":{"setting":%s}, "id":1}' % (new)
    response = xbmc.executeJSONRPC(query)
    wiz.log("Unknown Sources Get Settings: %s" % str(response), xbmc.LOGDEBUG)
    if 'false' in response:
        _thread.start_new_thread(dialogWatch, ())
        xbmc.sleep(200)
        query = '{"jsonrpc":"2.0", "method":"Settings.SetSettingValue","params":{"setting":%s,"value":%s}, "id":1}' % (new, value)
        response = xbmc.executeJSONRPC(query)
        wiz.LogNotify("[COLOR %s]%s[/COLOR]" % (COLOR1, ADDONTITLE), '[COLOR %s]Unknown Sources:[/COLOR] [COLOR %s]Enabled[/COLOR]' % (COLOR1, COLOR2))
        wiz.log("Unknown Sources Set Settings: %s" % str(response), xbmc.LOGDEBUG)
        
def dialogWatch():
    x = 0
    while not xbmc.getCondVisibility("Window.isVisible(yesnodialog)") and x < 100:
        x += 1
        xbmc.sleep(100)
    
    if xbmc.getCondVisibility("Window.isVisible(yesnodialog)"):
        xbmc.executebuiltin('SendClick(11)')